package Wordstat::WebInterface::Controller::Statistics;

use qbit;

use base qw(QBit::WebInterface::Controller::BEMHTML);

use LWP::UserAgent;
use Digest::MD5 qw(md5_hex);
use Fcntl ':flock';
use JavaScript::V8;

__PACKAGE__->mk_ro_accessors('ua');

__PACKAGE__->model_accessors(
    api_advq        => 'QBit::Application::Model::API::Yandex::ADVQ',
    geobase         => 'QBit::Application::Model::Yandex::Geobase',
    cbb             => 'QBit::Application::Model::Yandex::CBB',
    flash_cookie    => 'QBit::Application::Model::Yandex::FlashCookie',
    api_bot_blocker => 'QBit::Application::Model::API::Yandex::BotBlocker',
);

my %GEO2AMMAP = ();
foreach my $type (qw(world russia ukraine turkey)) {
    my $method = "_geo2ammap_$type";
    push_hs(%GEO2AMMAP, __PACKAGE__->$method());
}

my %V8Context;

my $START_VAL_SUB = sub {'"' . substr(md5_hex(rand()), int(rand(5)), int(rand(11)) + 2) . '"'};

my @MIDDLE_FUNCS = (
    sub {
        return "$_[0].concat(" . int(rand(1000000)) . '^' . int(rand(1000000)) . ").substr(" . int(rand(6)) . ")";
    },
    sub {
        return "$_[0].split('').reverse().join('')";
    },
    sub {
        return "$_[0].split('a').join('b')";
    },
);

my @END_FUNCS = (
    sub {
        my $var_f = 'f' . int(rand(1000));
        my $var_v = 'v' . int(rand(1000));
        my $var_t = 't' . int(rand(1000));

        return
            "var $var_f = function($var_v){"
          . "var $var_t = "
          . $START_VAL_SUB->() . ";"
          . "return function(){return $var_t.concat($var_v)}"
          . "}($_[0]);"
          . "$var_f()";
    },

    sub {
        my $var_f  = 'f' . int(rand(1000));
        my $var_v  = 'v' . int(rand(1000));
        my $var_t  = 't' . int(rand(1000));
        my $var_tv = 'tv' . int(rand(1000));

        return
            "var $var_f = function($var_v){"
          . "var $var_t="
          . $START_VAL_SUB->() . ";"
          . "var $var_tv=$var_v;"
          . "return function($var_v){"
          . "return $var_t.concat($var_v.concat($var_tv))" . "}("
          . $START_VAL_SUB->() . ")" . "};"
          . "$var_f($_[0])";
    },
);

sub MODIFY_CODE_ATTRIBUTES {
    my ($package, $sub, @attrs) = @_;

    my @unknown_attrs = ();

    foreach my $attr (@attrs) {
        if ($attr =~ /^DATACMD$/) {
            $package->_register_cmd($sub, 'DATACMD', '_process_data_cmd');
            $package->_set_cmd_attr($sub, DATACMD => TRUE);
        } else {
            push(@unknown_attrs, $attr);
        }
    }

    return $package->SUPER::MODIFY_CODE_ATTRIBUTES($sub, @unknown_attrs);
}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{'ua'} = LWP::UserAgent->new();
}

sub page : CMD : DEFAULT {
    my ($self) = @_;

    return $self->from_bem_template('statistics/page.bem.tt2');
}

sub _die : CMD {
    my ($self) = @_;

    return $self / 0;
}

sub _fix_region {
    my ($self, $regs) = @_;

    my @regions = @$regs;

    if ($self->get_option('geo_rkim_nash', 0)) {
        my $parents_rf = $self->geobase->_get_lookup()->parents(225);
        if (@regions && grep(in_array($_, [225, @$parents_rf]), @regions)) {
            push(@regions, 977) if !in_array(-977, [@regions]);
        }
    } else {
        my $parents_ua = $self->geobase->_get_lookup()->parents(187);
        if (@regions && grep(in_array($_, [187, @$parents_ua]), @regions)) {
            push(@regions, 977) if !in_array(-977, [@regions]);
        }
    }

    return \@regions;
}

sub words : DATACMD {
    my ($self) = @_;

    return ('statistics/words_empty.bem.tt2') unless $self->request->param('words', '') =~ /\S/;

    my @regions = split(/[^\d\-]+/, $self->request->param('regions') || '');
    my $regions_p = join(",", @{$self->_fix_region(\@regions)});

    my $data = $self->api_advq->search7(
        words        => $self->request->param('words', ''),
        ph_page      => $self->request->param('page',  1) - 1,
        regions      => $regions_p,
        dbname       => $self->_get_advq_dbname,
        devices      => $self->_get_advq_devices,
        ph_page_size => 50,
        parser       => 'direct',
    )->[0];

    my $stat_limit_reached = $self->request->param('page',  1) == 41;

    return ('statistics/words.bem.tt2', vars => {data => $data, stat_limit_reached => $stat_limit_reached});
}

sub regions : DATACMD {
    my ($self) = @_;

    return ('statistics/regions_empty.bem.tt2') unless $self->request->param('words', '') =~ /\S/;

    my $data = $self->api_advq->search7(
        words            => $self->request->param('words', ''),
        count_by_regions => TRUE,
        dbname           => $self->_get_advq_dbname,
        devices          => $self->_get_advq_devices,
        parser           => 'direct',
    )->[0];

    my $cr = (grep($_->{reg_id} == 977, @{$data->{stat}->{count_by_regions}}))[0];
    my $parents_rf = $self->geobase->_get_lookup()->parents(225);
    my $parents_ua = $self->geobase->_get_lookup()->parents(187);
    foreach my $reg (@{$data->{stat}->{count_by_regions}}) {
        if ($self->get_option('geo_rkim_nash', 0)) {
            $reg->{cnt} += $cr->{cnt} if $cr &&  in_array($reg->{reg_id}, [225, @$parents_rf]);
        } else {
            $reg->{cnt} += $cr->{cnt} if $cr && in_array($reg->{reg_id}, [187, @$parents_ua]);
        }
    }

    my %prep_data = (cities => [], regions => []);
    foreach my $region (@{$data->{'stat'}{'count_by_regions'}}) {
        my $reg_geo = $self->geobase->get_region_by_id($region->{'reg_id'});
        next unless $reg_geo;
        push(
            @{$prep_data{$reg_geo->{'type'} < 6 ? 'regions' : 'cities'}},
            {
                cnt  => $region->{'cnt'},
                pp   => int($region->{'pp'} * 100),
                name => $self->geobase->get_geo_name($reg_geo),
                ($GEO2AMMAP{$region->{'reg_id'}} ? (am => $GEO2AMMAP{$region->{'reg_id'}}) : ()),
                ($self->get_option('geo_rkim_nash', 0) && $region->{'reg_id'} == 977 ? ('am' => 'RU_KR') : ()),
                ($self->get_option('geo_rkim_nash', 0) && $region->{'reg_id'} == 959 ? ('am' => 'RU_SC') : ()),
            }
        );
    }

    return ('statistics/regions.bem.tt2',
        vars => {data => $data, prep_data => \%prep_data, thousands_sep => $self->app->get_thousands_sep()});
}

# params:
#   period - 'monthly' | 'weekly' - группировка данных
#   words  - запрос
#   regions - регионы
#
sub history : DATACMD {
    my ($self) = @_;

    my $period = $self->request->param('period', 'monthly');

    return ('statistics/history_empty.bem.tt2') unless $self->request->param('words', '') =~ /\S/;

    my @regions = split(/[^\d\-]+/, $self->request->param('regions') || '');
    my $regions_p = join(",", @{$self->_fix_region(\@regions)});
    my $db_p = $self->request->param('db',  '');
    $db_p = '' unless in_array($db_p, ['mobile']);

    my $monthly;
    my $weekly;
    if ($period eq 'monthly') {
        $monthly = $self->api_advq->chrono7(
            words   => $self->request->param('words', ''),
            type    => 'monthly',
            regions => $regions_p,
            dbname  => $self->_get_advq_dbname,
            devices => $self->_get_advq_devices,
            parser  => 'direct',
        )->[0];
        foreach (@{$monthly->{'hist'}}) {
            $_->{'start_date'} = trdate(norm => db => [$_->{'year'}, $_->{'month'}, 1]);
            $_->{'date'} =
              trdate(norm => db =>
                  [$_->{'year'}, $_->{'month'}, trdate(norm => days_in_month => [$_->{'year'}, $_->{'month'}, 1])]);
        }
    } elsif ($period eq 'weekly') {
        $weekly = $self->api_advq->chrono7(
            words   => $self->request->param('words', ''),
            type    => 'weekly',
            regions => $regions_p,
            dbname  => $self->_get_advq_dbname,
            devices => $self->_get_advq_devices,
            parser  => 'direct',
        )->[0];

        foreach (@{$weekly->{'hist'}}) {
            $_->{'start_date'} = delete($_->{'monday'});
            $_->{'date'} = date_add($_->{'start_date'}, iformat => 'db', oformat => 'db', day => 6);
        }
    }

    # fix (still no data from backend)
    $monthly->{'stat'}->{'valid_query'} = 1 if ($monthly->{'stat'} && !exists($monthly->{'stat'}->{'valid_query'}));
    $weekly->{'stat'}->{'valid_query'} = 1 if ($weekly->{'stat'} && !exists($weekly->{'stat'}->{'valid_query'}));

    return (
        'statistics/history.bem.tt2',
        vars => {
            monthly       => $monthly,
            weekly        => $weekly,
            decimal_point => $self->app->get_decimal_point(),
            thousands_sep => $self->app->get_thousands_sep()
        }
    );
}

sub regions_tree : CMD {
    my ($self) = @_;

    my %tr_locale = (uk => 'ua');
    my $locale = $self->get_option('locale', '');
    $locale = $tr_locale{$locale} if exists($tr_locale{$locale});

    my $file;
    if ($self->get_option('geo_rkim_nash', 0)) {
        $file = sprintf($self->get_option('region_tree_url_ru'), $locale);
    } else {
        $file = sprintf($self->get_option('region_tree_url_ur'), $locale);
    }

    my $content = readfile($file);

    throw "no file" unless $content;

    $content =~
s/\Qopener.window.showGeo(bid, regions_id, regions_name_with_comas);\E/window.parent.setRegions(regions_id, regions_name_with_comas);/;
    $content =~ s/\Qwindow.close();\E//;

    $self->response->content_type('text/html; charset=UTF-8');
    $self->response->data(\$content);
    $self->response->headers->{'X-Frame-Options'} = 'SAMEORIGIN';
}

sub pre_cmd {
    my ($self) = @_;

    $self->timelog->start('Controller pre_cmd');

    # Проверяем на блок в CBB
    $self->timelog->start('Checking flag 15');
    my $is_blocked = $self->cbb->check_ip_flag($self->request->remote_addr, 15);
    $self->timelog->finish();

    my $cur_user = $self->get_option('cur_user');

    # Проверяем Magick Cookie
    $self->timelog->start('Checking magical cookie');
    my $magical_cookie = $self->request->cookie('direct_advq');
    my $is_magical     =
           $magical_cookie
        && ($magical_cookie eq md5_hex(
                  $self->get_option('SecretPhrase')
                . $self->request->remote_addr
                . $self->request->http_header('X-Forwarded-For'))
            || $magical_cookie eq md5_hex(
                  $self->get_option('SecretPhrase')
                . $self->request->remote_addr
                . ($cur_user->{id} || 'asdf'))
           ) ? 1 : 0;

    ldump(
        {
            'Magical cookie error' => {
                IP              => $self->request->remote_addr,
                X_FORWARDED_FOR => $self->request->http_header('X-Forwarded-For'),
                UID             => $cur_user->{id},
                COOKIE          => $magical_cookie,
            }
        }
    ) if $magical_cookie && !$is_magical;
    $self->timelog->finish();

    # do more magic
    $is_magical = 2 if !$is_magical && $self->cbb->check_ip_flag($self->request->remote_addr, 171);
    l("extra region (171): ".($is_magical || '-')) if $is_magical && $is_magical == 2;
    # do more local magic
    $is_magical = 2 if $self->get_option('regions', [0])->[0] == 9999;

    # Проверяем в BotBlocker'е
    my $bot_blocker  = {};

    my $flash_cookie = $self->request->cookie('fuid01');

    if (!$is_blocked && $cur_user->{login} && !$is_magical) {
        $self->timelog->start('Checking in BotBlocker');
        try {
            $bot_blocker = $self->api_bot_blocker->check($self->request->remote_addr, $cur_user->{login});
        };
        $bot_blocker = {map {$_ => TRUE} values(%$bot_blocker)};
        $is_blocked = $bot_blocker->{'BLOCK'};
        $self->timelog->finish();
    }

    # !!!
    $is_blocked = 1 if $self->get_option('region_debug', '') && $self->request->param('words', '') eq 'пиво';

    # Обработка и шифрование
    if ($self->attrs->{'DATACMD'}) {
        if ($self->request->method() ne 'POST') {
            $self->timelog->finish();
            return $self->break($self->response->status(400));
        }

        if ($is_blocked) {
            $self->_log_request_type('data_blocked');
            $self->timelog->finish();
            return $self->break($self->as_json({blocked => TRUE}));
        }

        my $need_login = 1 unless $self->get_option('cur_user')->{'login'};

        if ($need_login) {
            $self->_log_request_type('data_need_login');
            $self->as_json({need_login => 1});
            $self->timelog->finish();
            return $self->break();
        } else {
            $self->_log_request_type('data_normal');
        }
    } else {
        if ($is_blocked) {
            $self->_log_request_type('data_blocked');
            $self->timelog->finish();
            return $self->break($self->redirect2url_internal('/block'));
        }

        $self->_log_request_type('other');
    }

    $self->timelog->finish();
}

sub _get_advq_dbname {
    my ($self) = @_;

    my $dbname = $self->get_option('locale', '') eq 'tr' ? 'tur' : 'rus';

    return $dbname;
}

sub _get_advq_devices {
    my ($self) = @_;

    my $devices = 'all';
    $devices = 'phone,tablet' if $self->request->param('db',  '') eq 'mobile';
    $devices = 'phone' if $self->request->param('db',  '') eq 'phone';
    $devices = 'tablet' if $self->request->param('db',  '') eq 'tablet';
    $devices = 'desktop' if $self->request->param('db',  '') eq 'desktop';

    return $devices;
}

sub _gen_js_key_code {
    my ($self) = @_;

    return $END_FUNCS[int(rand(scalar(@END_FUNCS)))]->(
        $MIDDLE_FUNCS[int(rand(scalar(@MIDDLE_FUNCS)))]->(
            $MIDDLE_FUNCS[int(rand(scalar(@MIDDLE_FUNCS)))]
              ->($MIDDLE_FUNCS[int(rand(scalar(@MIDDLE_FUNCS)))]->($START_VAL_SUB->()))
        )
    );
}

sub _process_data_cmd {
    my ($self, $template, %opts) = @_;

    my $bem_json = $self->_process_bem_template($template, %opts);

    my $data = to_json($self->_bemjson2data($$bem_json));
    $data = uri_escape($data);

    unless (exists($V8Context{$$})) {
        $self->timelog->start(gettext('Creating V8 context'));
        $V8Context{$$} = JavaScript::V8::Context->new();
        $self->timelog->finish;
    }

    my $js_key_code = $self->_gen_js_key_code();
    my $key         = $V8Context{$$}->eval($js_key_code);
    throw gettext("Error in JS: %s\n%s", $@, $js_key_code) if !defined($key);

    my @key = map {ord($_)}
      split('',
        substr($self->request->http_header('User-Agent'), 0, 25) . ($self->request->cookie('fuid01') // '') . $key);

    my $i = -1;
    $data = join('', map {chr(ord($_) ^ $key[++$i % @key])} split('', $data));

    return $self->as_json({data => $data, key => $js_key_code});
}

sub _log_request_type {
    my ($self, $type) = @_;

    my $dir = $self->get_option('log_request_type_dir');
    mkdir($dir) || throw "Cannot create dir: $!" unless -d $dir;

    my $fn = "$dir/$type";
    writefile($fn, "0\n") unless -f $fn;

    open(my $fh, "+<", $fn) || throw "Cannot open file $fn: $!";
    flock($fh, LOCK_EX);
    my $cnt = <$fh>;
    $cnt++;
    truncate($fh, 0);
    seek($fh, 0, 0);
    print $fh "$cnt\n";
    flock($fh, LOCK_UN);
    close($fh);

    $self->response->headers->{'X-REQUEST-TYPE'} = $type;
}

sub _geo2ammap_world {
    return (
        210    => 'AE',    # United Arab Emirates
        10090  => 'AF',    # Afghanistan
        10054  => 'AL',    # Albania
        168    => 'AM',    # Armenia
        21182  => 'AO',    # Angola
        93     => 'AR',    # Argentina
        113    => 'AT',    # Austria
        211    => 'AU',    # Australia
        167    => 'AZ',    # Azerbaijan
        10057  => 'BA',    # Bosnia and Herzegovina
        10091  => 'BD',    # Bangladesh
        114    => 'BE',    # Belgium
        21165  => 'BF',    # Burkina Faso
        115    => 'BG',    # Bulgaria
        21214  => 'BI',    # Burundi
        20869  => 'BJ',    # Benin
        20274  => 'BN',    # Brunei Darussalam
        10015  => 'BO',    # Bolivia
        94     => 'BR',    # Brazil
        21325  => 'BS',    # Bahamas
        21550  => 'BT',    # Bhutan
        21239  => 'BW',    # Botswana
        149    => 'BY',    # Belarus
        21544  => 'BZ',    # Belize
        95     => 'CA',    # Canada
        20762  => 'CD',    # The Democratic Republic of the Congo
        21007  => 'CF',    # Central African Republic
        21198  => 'CG',    # Republic of Congo
        126    => 'CH',    # Switzerland
        20733  => 'CI',    # Cote D'ivoire
        20862  => 'CL',    # Chile
        20736  => 'CM',    # Cameroon
        134    => 'CN',    # China
        21191  => 'CO',    # Colombia
        21131  => 'CR',    # Costa Rica
        10017  => 'CU',    # Cuba
        20574  => 'CY',    # Cyprus
        125    => 'CZ',    # Czech Republic
        96     => 'DE',    # Germany
        21476  => 'DJ',    # Djibouti
        203    => 'DK',    # Denmark
        20917  => 'DO',    # Dominican Republic
        20826  => 'DZ',    # Algeria
        20785  => 'EC',    # Ecuador
        179    => 'EE',    # Estonia
        1056   => 'EG',    # Egypt
        20989  => 'ER',    # Eritrea
        204    => 'ES',    # Spain
        20768  => 'ET',    # Ethiopia
        101519 => 'FK',    # Falkland Islands
        123    => 'FI',    # Finland
        10030  => 'FJ',    # Fiji
        124    => 'FR',    # France
        21137  => 'GA',    # Gabon
        102    => 'GB',    # United Kingdom
        169    => 'GE',    # Georgia
        21451  => 'GF',    # French Guiana
        20802  => 'GH',    # Ghana
        21567  => 'GL',    # Greenland
        21010  => 'GM',    # The Gambia
        20818  => 'GN',    # Guinea
        21045  => 'GQ',    # Equatorial Guinea
        246    => 'GR',    # Greece
        20968  => 'GT',    # Guatemala
        21143  => 'GW',    # Guinea-Bissau
        21477  => 'GY',    # Guyana
        21175  => 'HN',    # Honduras
        10083  => 'HR',    # Croatia
        21321  => 'HT',    # Haiti
        116    => 'HU',    # Hungary
        10095  => 'ID',    # Indonesia
        10063  => 'IE',    # Ireland
        181    => 'IL',    # Israel
        994    => 'IN',    # India
        20572  => 'IQ',    # Iraq
        10536  => 'IR',    # Iran
        10064  => 'IS',    # Iceland
        205    => 'IT',    # Italy
        10013  => 'JM',    # Jamaica
        10535  => 'JO',    # Jordan
        137    => 'JP',    # Japan
        21223  => 'KE',    # Kenya
        207    => 'KG',    # Kyrgyzstan
        20975  => 'KH',    # Cambodia
        10104  => 'KP',    # North Korea
        135    => 'KR',    # South Korea
        104491 => 'KV',    # Kosovo
        10537  => 'KW',    # Kuwait
        159    => 'KZ',    # Kazakhstan
        20972  => 'LA',    # Lao People's Democratic Republic
        10538  => 'LB',    # Lebanon
        10109  => 'LK',    # Sri Lanka
        21133  => 'LR',    # Liberia
        21261  => 'LS',    # Lesotho
        117    => 'LT',    # Lithuania
        21204  => 'LU',    # Luxembourg
        206    => 'LV',    # Latvia
        10023  => 'LY',    # Libya
        10020  => 'MA',    # Morocco
        208    => 'MD',    # Moldova
        21610  => 'ME',    # Montenegro
        20854  => 'MG',    # Madagascar
        10068  => 'MK',    # Macedonia
        21004  => 'ML',    # Mali
        10100  => 'MM',    # Myanmar
        10099  => 'MN',    # Mongolia
        21349  => 'MR',    # Mauritania
        21151  => 'MW',    # Malawi
        20271  => 'MX',    # Mexico
        10097  => 'MY',    # Malaysia
        21235  => 'MZ',    # Mozambique
        21217  => 'NA',    # Namibia
        21584  => 'NC',    # New Caledonia
        21339  => 'NE',    # Niger
        20741  => 'NG',    # Nigeria
        21231  => 'NI',    # Nicaragua
        118    => 'NL',    # Netherlands
        119    => 'NO',    # Norway
        10101  => 'NP',    # Nepal
        139    => 'NZ',    # New Zealand
        21586  => 'OM',    # Oman
        21300  => 'PA',    # Panama
        21156  => 'PE',    # Peru
        20739  => 'PG',    # Papua New Guinea
        10108  => 'PH',    # Philippines
        10102  => 'PK',    # Pakistan
        120    => 'PL',    # Poland
        20764  => 'PR',    # Puerto Rico
        98552  => 'PS',    # Palestinian Territories
        10074  => 'PT',    # Portugal
        20992  => 'PY',    # Paraguay
        21486  => 'QA',    # Qatar
        10077  => 'RO',    # Romania
        180    => 'RS',    # Serbia
        225    => 'RU',    # Russian Federation
        21371  => 'RW',    # Rwanda
        10540  => 'SA',    # Saudi Arabia
        20915  => 'SB',    # Solomon Islands
        20957  => 'SD',    # Sudan
        127    => 'SE',    # Sweden
        122    => 'SI',    # Slovenia
        20986  => 'SJ',    # Svalbard and Jan Mayen
        121    => 'SK',    # Slovakia
        21219  => 'SL',    # Sierra Leone
        21441  => 'SN',    # Senegal
        21227  => 'SO',    # Somalia
        21344  => 'SR',    # Suriname
        20957  => 'SS',    # South Sudan
        20769  => 'SV',    # El Salvador
        10542  => 'SY',    # Syrian Arab Republic
        21251  => 'SZ',    # Swaziland
        21331  => 'TD',    # Chad
                           #''     => 'TF',    # French Southern and Antarctic Lands
        21171  => 'TG',    # Togo
        995    => 'TH',    # Thailand
        209    => 'TJ',    # Tajikistan
        21562  => 'TL',    # Timor-Leste
        170    => 'TM',    # Turkmenistan
        10024  => 'TN',    # Tunisia
        983    => 'TR',    # Turkey
        21187  => 'TT',    # Trinidad and Tobago
        29385  => 'TW',    # Taiwan
        21208  => 'TZ',    # Tanzania
        187    => 'UA',    # Ukraine
        21230  => 'UG',    # Uganda
        84     => 'US',    # United States
        21289  => 'UY',    # Uruguay
        171    => 'UZ',    # Uzbekistan
        21184  => 'VE',    # Venezuela
        10093  => 'VN',    # Viet Nam
        21556  => 'VU',    # Vanuatu
        21551  => 'YE',    # Yemen
        10021  => 'ZA',    # South Africa
        21196  => 'ZM',    # Zambia
        20954  => 'ZW',    # Zimbabwe
    );
}

sub _geo2ammap_russia {
    return (
        11004 => 'RU_AD',    # Adygey (Республики Адыгея)
        11235 => 'RU_AL',    # Altay (Алтайский край)
        11375 => 'RU_AM',    # Amur (Амурская область)
        10842 => 'RU_AR',    # Arkhangel'sk (Архангельская область)
        10946 => 'RU_AS',    # Astrakhan' (Астраханская область)
        11111 => 'RU_BK',    # Bashkortostan (Республика Башкортостан)
        10645 => 'RU_BL',    # Belgorod (Белгородская область)
        10650 => 'RU_BR',    # Bryansk (Брянская область)
        11330 => 'RU_BU',    # Buryat (Республика Бурятия)
        11024 => 'RU_CN',    # Chechnya (Чеченская Республика)
        11225 => 'RU_CL',    # Chelyabinsk (Челябинская область)
        10251 => 'RU_CK',    # Chukot (Чукотский автономный округ)
        11156 => 'RU_CV',    # Chuvash (Чувашская Республика)
        11010 => 'RU_DA',    # Dagestan (Республика Дагестан)
        10231 => 'RU_GA',    # Gorno-Altay (Республика Алтай)
        11012 => 'RU_IN',    # Ingush () (Республика Ингушетия)
        11266 => 'RU_IK',    # Irkutsk (Иркутская область)
        10687 => 'RU_IV',    # Ivanovo (Ивановская область)
        11013 => 'RU_KB',    # Kabardin-Balkar (Кабардино-Балкарская республика)
        11020 => 'RU_KC',    # Karachay-Cherkess (Карачаево-Черкесская республика)
        10995 => 'RU_KD',    # Krasnodar (Краснодарский край)
        11282 => 'RU_KE',    # Kemerovo (Кемеровская область)
        10693 => 'RU_KG',    # Kaluga (Калужская область)
        11457 => 'RU_KH',    # Khabarovsk (Хабаровский край)
        10933 => 'RU_KI',    # Karelia (Республика Карелия)
        11340 => 'RU_KK',    # Khakass (Республика Хакасия)
        11015 => 'RU_KL',    # Kalmyk (Республика Калмыкия)
        11193 => 'RU_KM',    # Khanty-Mansiy (Ханты-Мансийский АО)
        10857 => 'RU_KN',    # Kaliningrad (Калининградская область)
        10939 => 'RU_KO',    # Komi (Республика Коми)
        11398 => 'RU_KQ',    # Kamchatka (Камчатский край)
        10705 => 'RU_KS',    # Kursk (Курская область)
        10699 => 'RU_KT',    # Kostroma (Костромская область)
        11158 => 'RU_KU',    # Kurgan (Курганская область)
        11070 => 'RU_KV',    # Kirov (Кировская область)
        11309 => 'RU_KX',    # Krasnoyarsk (Красноярский край)
        10174 => 'RU_LN',    # Leningrad (Санкт-Петербург и Ленинградская область)
        10712 => 'RU_LP',    # Lipetsk (Липецкая область)
        213   => 'RU_MC',    # Moscow City (Москва)
        11077 => 'RU_ME',    # Mariy-El (Республика Марий-Эл)
        11403 => 'RU_MG',    # Magadan (Магаданская область)
        10897 => 'RU_MM',    # Murmansk (Мурманская область)
        11117 => 'RU_MR',    # Mordovia (Республика Мордовия)
        1     => 'RU_MS',    # Moskva (Москва и Московская область)
        10904 => 'RU_NG',    # Novgorod (Новгородская область)
        10176 => 'RU_NN',    # Nenets (Ненецкий Автономный округ)
        11021 => 'RU_NO',    # North Ossetia (Республика Северная Осетия-Алания)
        11316 => 'RU_NS',    # Novosibirsk (Новосибирская область)
        11079 => 'RU_NZ',    # Nizhegorod (Нижегородская область)
        11084 => 'RU_OB',    # Orenburg (Оренбургская область)
        10772 => 'RU_OL',    # Orel (Орловская область)
        11318 => 'RU_OM',    # Omsk (Омская область)
        11108 => 'RU_PE',    # Perm' (Пермский край)
        11409 => 'RU_PR',    # Primor'ye (Приморский край)
        10926 => 'RU_PS',    # Pskov (Псковская область)
        11095 => 'RU_PZ',    # Penza (Пензенская область)
        11029 => 'RU_RO',    # Rostov (Ростовская область)
        10776 => 'RU_RZ',    # Ryazan' (Рязанская область)
        11131 => 'RU_SA',    # Samara (Самарская область)
        11443 => 'RU_SK',    # Sakha (Республика Саха (Якутия))
        11450 => 'RU_SL',    # Sakhalin (Сахалинская область)
        10795 => 'RU_SM',    # Smolensk (Смоленская область)
        2     => 'RU_SP',    # Saint Petersburg City (Санкт-Петербург)
        11146 => 'RU_SR',    # Saratov (Саратовская область)
        11069 => 'RU_ST',    # Stavropol' (Ставропольский край)
        11162 => 'RU_SV',    # Sverdlovsk (Свердловская область)
        10802 => 'RU_TB',    # Tambov (Тамбовская область)
        11353 => 'RU_TO',    # Tomsk (Томская область)
        10832 => 'RU_TL',    # Tula (Тульская область)
        11119 => 'RU_TT',    # Tatarstan (Поволжье)
        10233 => 'RU_TU',    # Tuva (Республика Тыва)
        10819 => 'RU_TV',    # Tver' (Тверская область)
        11176 => 'RU_TY',    # Tyumen' (Тюменская область)
        11148 => 'RU_UD',    # Udmurt (Удмуртская республика)
        11153 => 'RU_UL',    # Ul'yanovsk (Ульяновская область)
        10950 => 'RU_VG',    # Volgograd (Волгоградская область)
        10658 => 'RU_VL',    # Vladimir (Владимирская область)
        11232 => 'RU_YN',    # Yamal-Nenets (Ямало-Ненецкий АО)
        10853 => 'RU_VO',    # Vologda (Вологодская область)
        10672 => 'RU_VR',    # Voronezh (Воронежская область)
        10841 => 'RU_YS',    # Yaroslavl' (Ярославская область)
        10243 => 'RU_YV',    # Yevrey (Еврейская автономная область)
        21949 => 'RU_ZB',    # Zabaykal'ye (Забайкальский край)
    );
}

sub _geo2ammap_ukraine {
    return (
        959   => 'UA_SC',    # Sevastpol' Crimea (Севастополь)
        977   => 'UA_KR',    # Crimea (Крым)
        20546 => 'UA_CK',    # Cherkasy (Черкасская область)
        20551 => 'UA_CH',    # Chernihiv (Черниговская область)
        20533 => 'UA_CV',    # Chernivtsi (Черновицкая область)
        20537 => 'UA_DP',    # Dnipropetrovs'k (Днепропетровская область)
        20536 => 'UA_DT',    # Donets'k (Донецкая область)
        20532 => 'UA_IF',    # Ivano-Frankivs'k (Ивано-Франковск)
        20538 => 'UA_KK',    # Kharkiv (Харьковская область)
        20542 => 'UA_KS',    # Kherson (Херсонская область)
        20535 => 'UA_KM',    # Khmel'nyts'kyy (Хмельницкая область)
        143   => 'UA_KC',    # Kiev City (Киев)
        20544 => 'UA_KV',    # Kiev (Киевская область)
        20548 => 'UA_KH',    # Kirovohrad (Кировоградская область)
        20540 => 'UA_LH',    # Luhans'k (Луганская область)
        20529 => 'UA_LV',    # L'viv (Львовская область)
        20543 => 'UA_MY',    # Mykolayiv (Николаевская область)
        20541 => 'UA_OD',    # Odessa (Одесская область)
        20549 => 'UA_PL',    # Poltava (Полтавская область)
        20534 => 'UA_RV',    # Rivne (Ровенская область)
        20552 => 'UA_SM',    # Sumy (Сумская область)
        20531 => 'UA_TP',    # Ternopil' (Тернопольская область)
        20530 => 'UA_ZK',    # Transcarpathia (Закарпатская область)
        20545 => 'UA_VI',    # Vinnytsya (Винницкая область)
        20550 => 'UA_VO',    # Volyn (Волынская область)
        20539 => 'UA_ZP',    # Zaporizhzhya (Запорожская область)
        20547 => 'UA_ZT',    # Zhytomyr (Житомирская область)
    );
}

sub _geo2ammap_turkey {
    return (
        103669 => 'TR_AA',    # Adana (Провинция Адана)
        103893 => 'TR_AD',    # Adıyaman (Провинция Адияман)
        103678 => 'TR_AF',    # Afyonkarahisar (Провинция Афьонкарахисар)
        103668 => 'TR_AG',    # Ağri (Провинция Агры)
        103672 => 'TR_AK',    # Aksaray (Провинция Аксарай)
        103673 => 'TR_AM',    # Amasya (Провинция Амасья)
        103674 => 'TR_AN',    # Ankara (Провинция Анкара)
        103675 => 'TR_AL',    # Antalya (Провинция Анталья)
        103676 => 'TR_AR',    # Ardahan (Провинция Ардахан)
        103677 => 'TR_AV',    # Artvin (Провинция Артвин)
        103671 => 'TR_AY',    # Aydın (Провинция Айдын)
        103680 => 'TR_BK',    # Balıkesir (Провинция Балыкесир)
        103681 => 'TR_BR',    # Bartın (Провинция Бартын)
        103682 => 'TR_BM',    # Batman (Провинция Батман)
        103679 => 'TR_BB',    # Bayburt (Провинция Байбурт)
        103683 => 'TR_BC',    # Bilecik (Провинция Биледжик)
        103684 => 'TR_BG',    # Bingöl (Провинция Бингёль)
        103685 => 'TR_BT',    # Bitlis (Провинция Битлис)
        103686 => 'TR_BL',    # Bolu (Провинция Болу)
        103687 => 'TR_BD',    # Burdur (Провинция Бурдур)
        103688 => 'TR_BU',    # Bursa (Провинция Бурса)
        103736 => 'TR_CK',    # Çanakkale (Провинция Чанаккале)
        103737 => 'TR_CI',    # Çankırı (Провинция Чанкыры)
        103738 => 'TR_CM',    # Çorum (Провинция Чорум)
        103693 => 'TR_DN',    # Denizli (Провинция Денизли)
        103694 => 'TR_DY',    # Diyarbakır (Провинция Диярбакыр)
        103695 => 'TR_DU',    # Düzce (Провинция Дюздже)
        103743 => 'TR_ED',    # Edirne (Провинция Эдирне)
        103744 => 'TR_EG',    # Elazığ (Провинция Элязыг)
        103745 => 'TR_EN',    # Erzincan (Провинция Эрзинджан)
        103746 => 'TR_EM',    # Erzurum (Провинция Эрзурум)
        103747 => 'TR_ES',    # Eskişehir (Провинция Эскишехир)
        103690 => 'TR_GA',    # Gaziantep (Провинция Газиантеп)
        103691 => 'TR_GI',    # Giresun (Провинция Гиресун)
        103692 => 'TR_GU',    # Gümüşhane (Провинция Гюмушхане)
        103734 => 'TR_HK',    # Hakkari (Провинция Хаккяри)
        103735 => 'TR_HT',    # Hatay (Провинция Хатай)
        103715 => 'TR_IC',    # Mersin (Провинция Мерсин)
        103741 => 'TR_IG',    # Iğdir (Провинция Ыгдыр)
        103742 => 'TR_IP',    # Isparta (Провинция Ыспарта)
        103728 => 'TR_IB',    # İstanbul (Провинция Стамбул)
        103697 => 'TR_IZ',    # İzmir (Провинция Измир)
        103704 => 'TR_KM',    # Kahramanmaraş (Провинция Кахраманмараш)
        103700 => 'TR_KB',    # Karabük (Провинция Карабюк)
        103701 => 'TR_KR',    # Karaman (Провинция Караман)
        103702 => 'TR_KA',    # Kars (Провинция Карс)
        103703 => 'TR_KS',    # Kastamonu (Провинция Кастамону)
        103699 => 'TR_KY',    # Kayseri (Провинция Кайсери)
        103705 => 'TR_KI',    # Kilis (Провинция Килис)
        103710 => 'TR_KK',    # Kırıkkale (Провинция Кырыккале)
        103708 => 'TR_KL',    # Kırklareli (Провинция Кыркларели)
        103709 => 'TR_KH',    # Kırşehir (Провинция Кыршехир)
        103706 => 'TR_KC',    # Kocaeli (Провинция Коджаэли)
        103707 => 'TR_KO',    # Konya (Провинция Конья)
        103711 => 'TR_KU',    # Kütahya (Провинция Кютахья)
        103712 => 'TR_ML',    # Malatya (Провинция Малатья)
        103713 => 'TR_MN',    # Manisa (Провинция Маниса)
        103714 => 'TR_MR',    # Mardin (Провинция Мардин)
        103716 => 'TR_MG',    # Muğla (Провинция Мугла)
        103717 => 'TR_MS',    # Muş (Провинция Муш)
        103718 => 'TR_NV',    # Nevşehir (Провинция Невшехир)
        103719 => 'TR_NG',    # Niğde (Провинция Нигде)
        103720 => 'TR_OR',    # Ordu (Провинция Орду)
        103721 => 'TR_OS',    # Osmaniye (Провинция Османие)
        103722 => 'TR_RI',    # Rize (Провинция Ризе)
        103723 => 'TR_SK',    # Sakarya (Провинция Сакарья)
        103724 => 'TR_SS',    # Samsun (Провинция Самсун)
        103739 => 'TR_SU',    # Şanlıurfa (Провинция Шанлиурфа)
        103726 => 'TR_SI',    # Siirt (Провинция Сиирт)
        103727 => 'TR_SP',    # Sinop (Провинция Синоп)
        103740 => 'TR_SR',    # Şırnak (Провинция Ширнак)
        103725 => 'TR_SV',    # Sivas (Провинция Сивас)
        103729 => 'TR_TG',    # Tekirdağ (Провинция Текирдаг)
        103730 => 'TR_TT',    # Tokat (Провинция Токат)
        103731 => 'TR_TB',    # Trabzon (Провинция Трабзон)
        103732 => 'TR_TC',    # Tunceli (Провинция Тунджели)
        103733 => 'TR_US',    # Uşak (Провинция Ушак)
        103689 => 'TR_VA',    # Van (Провинция Ван)
        103748 => 'TR_YL',    # Yalova (Провинция Ялова)
        103698 => 'TR_YZ',    # Yozgat (Провинция Йозгат)
        103696 => 'TR_ZO',    # Zonguldak (Провинция Зонгулдак)
    );
}

TRUE;
