
=encoding UTF-8
=cut

=head1 Название

Yandex::SecretKey - работа с секретным ключом.

=head1 Ссылки на документацию

L<http://wiki.yandex-team.ru/AlekseyPonomarev/secret-key>

Эта вещь прменяется, напрмер, вот тут http://wiki.yandex-team.ru/SergejjPuzankov/tune-api

=cut

package Yandex::SecretKey;

use strict;
use warnings;

use Digest::MD5 qw(md5_hex);

use base qw( Exporter );
our @EXPORT = qw(get_auth_secretkey get_not_auth_secretkey);

=head1 Методы

=head2 get_auth_secretkey

B<Параметры:> $uid

B<Возвращаемое значение:> $secretkey - строка из 33 символов

Ключ для авторизованных пользователей

Формула: "u" + md5( <uid> + "::" + <days> ), где days - это timestamp / 86400

=cut

sub get_auth_secretkey {
    my ($uid) = @_;

    return unless $uid;

    my $timestamp = time;
    my $string    = "$uid" . "::" . int($timestamp / 86400);
    return 'u' . md5_hex($string);
}

=head2 Ключ get_not_auth_secretkey

B<Параметры:> $cookie_yandexuid

B<Возвращаемое значение:> $secretkey - строка из 33 символов

Ключ для авторизованных пользователей

Формула: “y” + md5( “0:" + <cookie-yandexuid> + “:" + <days> ), где days – это timestamp / 86400

=cut

sub get_not_auth_secretkey {
    my ($yandexuid) = @_;

    return unless $yandexuid;

    my $timestamp = time;
    my $string    = "0:" . "$yandexuid" . ":" . int($timestamp / 86400);
    return 'y' . md5_hex($string);
}

1;
