package Yandex::Tanker::JSON;
{
  $Yandex::Tanker::JSON::VERSION = '2.4.2';
}

# ABSTRACT: Cross platform working with json data


use strict;
use warnings FATAL => 'all';
use 5.008;

use Carp;
use JSON qw();

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(
    from_json
    to_json
);


sub from_json {
    my ($json) = @_;

    my $perl;

    if ($JSON::VERSION >= 2) {
        $perl = JSON::from_json($json);
    } else {
        $perl = JSON::jsonToObj($json);
    }

    return $perl;
}


sub to_json {
    my ($perl) = @_;

    my $json;

    if ($JSON::VERSION >= 2) {
        $json = JSON::to_json($perl);
    } else {
        $json = JSON::objToJson($perl);
    }

    return $json;
}

1;

__END__
=pod

=head1 NAME

Yandex::Tanker::JSON - Cross platform working with json data

=head1 VERSION

version 2.4.2

=head1 SYNOPSIS

Yandex::Tanker module is intended to work on different operaion systems. On
modern Ubuntu systems there is JSON with version more than 2.0, but on old
systems (for example, Ubuntu Hardy 8.04 LTS) there is JSON less than 2.0.

Interface in Perl module JSON is differect in different version of JSON
module. In the beginning it was using functions with the names objToJson()
and jsonToObj(). But starting from version 2.0 JSON module uses functions
from_json() and to_json().

To make it possible to use Yandex::Tanker of Ubuntu hardy (and, probaly, other
old systems) this layer was created.

=head2 from_json

    my $perl_scalar = from_json('{ "a": "b" }');

=head2 to_json

    my $json = to_json(
        {
            a => 'b',
        }
    );

=head1 AUTHOR

Ivan Bessarabov <bessarabov@yandex-team.ru>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Yandex.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

