
=encoding UTF-8
=cut

=head1 Название

Yandex::Utils - общие сабы для инфраструктуры Яндекса.

=cut

package Yandex::Utils;

use strict;
use warnings;

use base qw( Exporter );
our @EXPORT = qw(get_yandex_domain);

=head1 Методы

=head2 get_yandex_domain

    get_yandex_domain('beta.partner.yandex.ru');     # yandex.ru
    get_yandex_domain('beta.partner.yandex.com.tr'); # yandex.com.tr
    get_yandex_domain('http://beta.partner.yandex.ru:8062/settings');   # yandex.ru

=cut

sub get_yandex_domain {
    my ($server_name) = @_;
    $server_name =~ m{(yandex\.(:?ru|ua|by|kz|com|com\.tr))(:?\:\d+)?(:?/.*)?$};
    return $1 ? $1 : '';
}

1;
