use Test::More tests => 4;
use Test::MockObject;

use qbit;

use Wordstat::Application;

my $app = Wordstat::Application->new();

$app->set_option(
    last_captcha_interval => 1 * 60,
);

$app->pre_run();


# -----------------------------------------------
our $COOK = {
    fuid01  => 123,
    wsst    => '10fcec37814646ce1a3b3a45d0ebc8091|52448c3f',
};
our $REMOTE_ADDR = '127.0.0.1';

my $req = Test::MockObject->new()->mock(
    cookie => sub {
        return $COOK->{$_[1]};
    }
)->mock(
    remote_addr => sub {
        $REMOTE_ADDR;
    }
);



# -----------------------------------------------
# check UID
{
    is($app->ws_captcha->last_success_compute_uid(request => $req), '1|127.0.0.1|123', 'check uid (v1: ip+fuid01 fuid)');

    local $COOK->{fuid01} = undef;
    is($app->ws_captcha->last_success_compute_uid(request => $req), undef, 'check uid (no fuid)');
}
# -----------------------------------------------
# check _last_success_data_sign
{
    is($app->ws_captcha->_last_success_data_sign(key => 'key', data => ['d1', 'd2']), 'e24f98759ee820c4381b8cd606f01d4ed1|d2', 'sign data "d1", "d2"');
    is($app->ws_captcha->_last_success_data_sign(key => 'key', data => ['d1']), 'b443692171cca401dc87bea2a632b4c5d1', 'sign data "d1"');
}

# -----------------------------------------------


$app->post_run();
