/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import mx4j.remote.ConnectionNotificationEmitter;
import mx4j.remote.ConnectionResolver;
import mx4j.remote.HeartBeat;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.tools.remote.AbstractJMXConnector;
import mx4j.tools.remote.http.HTTPConnection;
import mx4j.tools.remote.http.HTTPConnectionMBeanServerConnection;
import mx4j.tools.remote.http.HTTPHeartBeat;
import mx4j.tools.remote.http.HTTPRemoteNotificationClientHandler;

public class HTTPConnector
extends AbstractJMXConnector {
    private transient HTTPConnection connection;
    private transient String connectionId;
    private transient HeartBeat heartbeat;
    private transient RemoteNotificationClientHandler notificationHandler;

    public HTTPConnector(JMXServiceURL address, Map environment) throws IOException {
        super(address);
    }

    protected void doConnect(Map environment) throws IOException, SecurityException {
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment);
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        HTTPConnection temp = (HTTPConnection)resolver.lookupClient(address, environment);
        this.connection = (HTTPConnection)resolver.bindClient(temp, environment);
        Object credentials = environment == null ? null : environment.get("jmx.remote.credentials");
        this.connectionId = this.connection.connect(credentials);
        this.heartbeat = this.createHeartBeat(this.connection, this.getConnectionNotificationEmitter(), environment);
        this.notificationHandler = this.createRemoteNotificationClientHandler(this.connection, this.getConnectionNotificationEmitter(), this.heartbeat, environment);
        this.heartbeat.start();
        this.notificationHandler.start();
    }

    protected HeartBeat createHeartBeat(HTTPConnection connection, ConnectionNotificationEmitter emitter, Map environment) {
        return new HTTPHeartBeat(connection, emitter, environment);
    }

    protected RemoteNotificationClientHandler createRemoteNotificationClientHandler(HTTPConnection connection, ConnectionNotificationEmitter emitter, HeartBeat heartbeat, Map environment) {
        return new HTTPRemoteNotificationClientHandler(connection, emitter, heartbeat, environment);
    }

    protected MBeanServerConnection doGetMBeanServerConnection(Subject delegate) throws IOException {
        return new HTTPConnectionMBeanServerConnection(this.getHTTPConnection(), delegate, this.getRemoteNotificationClientHandler());
    }

    protected void doClose() throws IOException {
        if (this.notificationHandler != null) {
            this.notificationHandler.stop();
        }
        if (this.heartbeat != null) {
            this.heartbeat.stop();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    protected HTTPConnection getHTTPConnection() {
        return this.connection;
    }

    protected RemoteNotificationClientHandler getRemoteNotificationClientHandler() {
        return this.notificationHandler;
    }
}

