/*
 * Decompiled with CFR 0.152.
 */
package com.tf.se.adapter.impl;

import com.tf.se.adapter.AdapterMessageException;
import com.tf.se.adapter.impl.XMLPrinter;
import com.tf.se.adapter.intfs.AdapterG2IF;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdapterG2
implements AdapterG2IF {
    public static final String AUTHOR = "ThinkFree Server Dev Team";
    public static final String PROPERTY = "property";
    public static final String MODIFIED = "modified";
    public static final String NAME = "name";
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String SIZE = "size";
    public static final String LOCKED = "locked";
    public static final String OWNER = "locker";
    public static final String LIST = "list";
    public static final String TYPE = "type";
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_FILE = "file";
    public static final String SEPARATOR = File.separator;
    public static final String ROOT_SEPARATOR = "";
    protected transient ResourceBundle resource = null;
    protected static HashMap<String, String> lockTable = new HashMap(1);
    protected static HashMap<String, String> debugInfos = new HashMap();
    public static boolean isDebug = false;
    public static final int DEBUG_POSITION_START = 1;
    public static final int DEBUG_POSITION_ING = 2;
    public static final int DEBUG_POSITION_STOP = 3;
    public static final String DEBUG_API_NAME_START = "start()";
    public static final String DEBUG_API_NAME_STOP = "stop()";
    public static final String DEBUG_API_NAME_LEVEL = "level()";
    public static final String DEBUG_API_NAME_INFO = "info()";
    public static final String DEBUG_API_NAME_LIST = "list()";
    public static final String DEBUG_API_NAME_GET = "get()";
    public static final String DEBUG_API_NAME_PUT = "put()";
    public static final String DEBUG_API_NAME_PUTAS = "putAs()";
    public static final String DEBUG_API_NAME_LOCK = "lock()";
    public static final String DEBUG_API_NAME_UNLOCK = "unlock()";
    public static final String DEBUG_API_NAME_RENAME = "rename()";
    public static final String DEBUG_API_NAME_MKDIR = "mkdir()";
    public static final String DEBUG_API_NAME_DELETE = "delete()";

    public ResourceBundle getResource(String string, Locale locale) {
        if (this.resource == null) {
            this.resource = locale == null ? ResourceBundle.getBundle(string, Locale.getDefault()) : ResourceBundle.getBundle(string, locale);
        }
        return this.resource;
    }

    public String getInfo(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            string2 = (String)httpServletRequest.getAttribute(string);
        }
        return string2;
    }

    public String toXML(File file) throws AdapterMessageException {
        return this.toXML(file, false);
    }

    public String toXML(File file, boolean bl) throws AdapterMessageException {
        XMLPrinter xMLPrinter = new XMLPrinter();
        if (bl) {
            xMLPrinter.writeElement(null, LIST, 0);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                this.writeFileInfo(xMLPrinter, file2);
            }
            xMLPrinter.writeElement(null, LIST, 1);
        } else {
            this.writeFileInfo(xMLPrinter, file);
        }
        return xMLPrinter.toString();
    }

    private void writeFileInfo(XMLPrinter xMLPrinter, File file) throws AdapterMessageException {
        boolean bl = this.canRead(file);
        boolean bl2 = this.canWrite(file);
        xMLPrinter.writeElement(null, PROPERTY, 0);
        xMLPrinter.writeProperty(null, null, NAME, file.getName(), true);
        xMLPrinter.writeProperty(null, TYPE, file.isDirectory() ? TYPE_FOLDER : TYPE_FILE);
        xMLPrinter.writeProperty(null, MODIFIED, file.lastModified() + ROOT_SEPARATOR);
        xMLPrinter.writeProperty(null, READ, bl + ROOT_SEPARATOR);
        xMLPrinter.writeProperty(null, WRITE, bl2 + ROOT_SEPARATOR);
        xMLPrinter.writeProperty(null, SIZE, file.length() + ROOT_SEPARATOR);
        if (bl2) {
            String string = lockTable.get(file.getPath());
            if (string != null) {
                xMLPrinter.writeProperty(null, LOCKED, "true");
                xMLPrinter.writeProperty(null, WRITE, "false");
                xMLPrinter.writeProperty(null, OWNER, string);
            }
        } else {
            xMLPrinter.writeProperty(null, WRITE, "false");
        }
        xMLPrinter.writeElement(null, PROPERTY, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryLock(String string, String string2) {
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            String string3 = lockTable.get(string);
            if (string3 == null || string3.equals(string2)) {
                lockTable.put(string, string2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean releaseLock(String string, String string2) {
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            String string3 = lockTable.get(string);
            if (string3 != null && string3.equals(string2)) {
                lockTable.remove(string);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLockedFileConnection(String string) {
        String string2 = null;
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            string2 = lockTable.get(string);
        }
        return string2;
    }

    protected void setDebug() {
        String string = ResourceBundle.getBundle("com/tf/se/adapter/impl/common").getString("debug");
        if (string != null && Boolean.parseBoolean(string)) {
            isDebug = true;
        }
    }

    protected void log(int n, String string, HashMap<String, String> hashMap) {
        if (isDebug) {
            if (n == 1) {
                System.out.println("**************************************************START***************" + string);
            } else if (n == 3) {
                System.out.println("**************************************************STOP***************" + string);
            } else {
                System.out.println("***************************************************ING***************" + string);
            }
            if (hashMap != null) {
                for (String string2 : hashMap.keySet()) {
                    String string3 = hashMap.get(string2);
                    System.out.println("*******" + string2 + " : " + string3 + "********");
                }
            }
        }
    }

    public boolean canWrite(File file) {
        return file.canWrite();
    }

    public boolean canRead(File file) {
        return file.canRead();
    }

    @Override
    public boolean putAs(String string, InputStream inputStream, long l) throws AdapterMessageException {
        debugInfos.clear();
        debugInfos.put("url", string);
        debugInfos.put(SIZE, l + ROOT_SEPARATOR);
        this.log(1, DEBUG_API_NAME_PUTAS, debugInfos);
        return this.put(string, inputStream, l);
    }
}

