/*
 * Decompiled with CFR 0.152.
 */
package com.tf.se.adapter.impl;

import com.tf.se.adapter.AdapterMessageException;
import com.tf.se.adapter.impl.XMLPrinter;
import com.tf.se.adapter.intfs.AdapterG3IF;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractAdapterG3
implements AdapterG3IF {
    public static final String AUTHOR = "ThinkFree Server Dev Team";
    public static final String PROPERTY = "property";
    public static final String MODIFIED = "modified";
    public static final String NAME = "name";
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String SIZE = "size";
    public static final String LOCKED = "locked";
    public static final String OWNER = "locker";
    public static final String LIST = "list";
    public static final String TYPE = "type";
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_FILE = "file";
    public static final String SEPARATOR = File.separator;
    public static final String ROOT_SEPARATOR = "";
    protected transient ResourceBundle resource = null;
    protected static HashMap<String, String> lockTable = new HashMap();
    protected static HashMap<String, String> debugInfos = new HashMap();
    public static boolean isDebug = false;
    public static final int DEBUG_POSITION_START = 1;
    public static final int DEBUG_POSITION_ING = 2;
    public static final int DEBUG_POSITION_STOP = 3;
    public static final String DEBUG_API_NAME_START = "start()";
    public static final String DEBUG_API_NAME_STOP = "stop()";
    public static final String DEBUG_API_NAME_LEVEL = "level()";
    public static final String DEBUG_API_NAME_INFO = "info()";
    public static final String DEBUG_API_NAME_LIST = "list()";
    public static final String DEBUG_API_NAME_GET = "get()";
    public static final String DEBUG_API_NAME_PUT = "put()";
    public static final String DEBUG_API_NAME_PUTAS = "putAs()";
    public static final String DEBUG_API_NAME_LOCK = "lock()";
    public static final String DEBUG_API_NAME_UNLOCK = "unlock()";
    public static final String DEBUG_API_NAME_RENAME = "rename()";
    public static final String DEBUG_API_NAME_MKDIR = "mkdir()";
    public static final String DEBUG_API_NAME_DELETE = "delete()";

    public ResourceBundle getResource(String name, Locale locale) {
        if (this.resource == null) {
            this.resource = locale == null ? ResourceBundle.getBundle(name, Locale.getDefault()) : ResourceBundle.getBundle(name, locale);
        }
        return this.resource;
    }

    public String getInfo(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (value == null) {
            value = (String)request.getAttribute(name);
        }
        return value;
    }

    public String toXML(File file) throws AdapterMessageException {
        return this.toXML(file, false);
    }

    public String toXML(File file, boolean list) throws AdapterMessageException {
        XMLPrinter xml = new XMLPrinter();
        if (list) {
            xml.writeElement(null, LIST, 0);
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                this.writeFileInfo(xml, child);
            }
            xml.writeElement(null, LIST, 1);
        } else {
            this.writeFileInfo(xml, file);
        }
        return xml.toString();
    }

    private void writeFileInfo(XMLPrinter printer, File file) throws AdapterMessageException {
        boolean canRead = this.canRead(file);
        boolean canWrite = this.canWrite(file);
        printer.writeElement(null, PROPERTY, 0);
        printer.writeProperty(null, null, NAME, file.getName(), true);
        printer.writeProperty(null, TYPE, file.isDirectory() ? TYPE_FOLDER : TYPE_FILE);
        printer.writeProperty(null, MODIFIED, file.lastModified() + ROOT_SEPARATOR);
        printer.writeProperty(null, READ, canRead + ROOT_SEPARATOR);
        printer.writeProperty(null, WRITE, canWrite + ROOT_SEPARATOR);
        printer.writeProperty(null, SIZE, file.length() + ROOT_SEPARATOR);
        if (canWrite) {
            String owner = lockTable.get(file.getPath());
            if (owner != null) {
                printer.writeProperty(null, LOCKED, "true");
                printer.writeProperty(null, WRITE, "false");
                printer.writeProperty(null, OWNER, owner);
            }
        } else {
            printer.writeProperty(null, WRITE, "false");
        }
        printer.writeElement(null, PROPERTY, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryLock(String id, String owner) {
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            String value = lockTable.get(id);
            if (value == null || value.equals(owner)) {
                lockTable.put(id, owner);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean releaseLock(String id, String owner) {
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            String value = lockTable.get(id);
            if (value != null && value.equals(owner)) {
                lockTable.remove(id);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLockedFileConnection(String id) {
        String value = null;
        HashMap<String, String> hashMap = lockTable;
        synchronized (hashMap) {
            value = lockTable.get(id);
        }
        return value;
    }

    protected void setDebug() {
        String debug = ResourceBundle.getBundle("com/tf/se/adapter/impl/common").getString("debug");
        if (debug != null && Boolean.parseBoolean(debug)) {
            isDebug = true;
        }
    }

    protected void log(int position, String apiName, HashMap<String, String> infos) {
        if (isDebug) {
            if (position == 1) {
                System.out.println("**************************************************START***************" + apiName);
            } else if (position == 3) {
                System.out.println("**************************************************STOP***************" + apiName);
            } else {
                System.out.println("***************************************************ING***************" + apiName);
            }
            if (infos != null) {
                for (String key : infos.keySet()) {
                    String value = infos.get(key);
                    System.out.println("*******" + key + " : " + value + "********");
                }
            }
        }
    }

    public boolean canWrite(File file) {
        return file.canWrite();
    }

    public boolean canRead(File file) {
        return file.canRead();
    }
}

