/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public final class ChunkedIntList
extends AbstractList<Integer> {
    private static final int CHUNK_SIZE_BITS = 9;
    private static final int CHUNK_SIZE = 512;
    private static final int MASK = 511;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int[] EMPTY_CHUNK = new int[0];
    private static final int[][] EMPTY_CHUNKS = new int[0][];
    private int size = 0;
    private int chunksCount = 0;
    private int[] lastChunk = EMPTY_CHUNK;
    private int initialChunkCapacity;
    private int[][] chunks;
    private boolean shrinked = false;

    public ChunkedIntList() {
        this(0);
    }

    public ChunkedIntList(int initialCapacity) {
        if (initialCapacity <= 0) {
            this.initialChunkCapacity = 16;
            this.chunks = EMPTY_CHUNKS;
        } else {
            this.initialChunkCapacity = Math.min(initialCapacity, 512);
            int chunksRequired = initialCapacity + 511 >> 9;
            this.chunks = new int[chunksRequired][];
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + index);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.size) {
            this.size = Math.max(0, newSize);
            this.chunksCount = this.size + 511 >> 9;
            if (this.chunksCount == 0) {
                this.lastChunk = EMPTY_CHUNK;
                this.shrinked = false;
            } else {
                this.lastChunk = this.chunks[this.chunksCount - 1];
                this.shrinked = (this.size & 0x1FF) != 0;
            }
        } else {
            int newChunksCount = newSize + 511 >> 9;
            int newLastChunkSize = (newSize - 1 & 0x1FF) + 1;
            if (this.chunksCount < newChunksCount) {
                if (this.chunksCount == 0) {
                    this.chunks = new int[newChunksCount][];
                } else {
                    if (this.shrinked) {
                        Arrays.fill(this.lastChunk, this.size & 0x1FF, this.lastChunk.length, 0);
                        this.shrinked = false;
                    }
                    this.chunks[this.chunksCount - 1] = Arrays.copyOf(this.lastChunk, 512);
                    if (newChunksCount > this.chunks.length) {
                        this.chunks = (int[][])Arrays.copyOf(this.chunks, Math.max(newChunksCount, this.chunks.length << 1));
                    }
                }
                while (this.chunksCount < newChunksCount - 1) {
                    this.chunks[this.chunksCount++] = new int[512];
                }
                this.lastChunk = new int[newLastChunkSize];
                this.chunks[this.chunksCount++] = this.lastChunk;
            } else {
                if (this.shrinked) {
                    Arrays.fill(this.lastChunk, this.size & 0x1FF, this.lastChunk.length, 0);
                    this.shrinked = false;
                }
                this.lastChunk = Arrays.copyOf(this.lastChunk, newLastChunkSize);
                this.chunks[this.chunksCount - 1] = this.lastChunk;
            }
            this.size = newSize;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        this.chunksCount = 0;
        this.lastChunk = EMPTY_CHUNK;
        this.chunks = EMPTY_CHUNKS;
        this.shrinked = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Integer element) {
        this.addInt(element);
        return true;
    }

    public void addInt(int element) {
        int pos = this.size & 0x1FF;
        if (pos == 0) {
            this.lastChunk = new int[this.initialChunkCapacity];
            this.initialChunkCapacity = Math.min(this.initialChunkCapacity << 1, 512);
            if (this.chunksCount == this.chunks.length) {
                this.chunks = this.chunksCount == 0 ? (Object)new int[16][] : (int[][])Arrays.copyOf(this.chunks, this.chunksCount << 1);
            }
            this.chunks[this.chunksCount++] = this.lastChunk;
        } else if (pos == this.lastChunk.length) {
            this.lastChunk = Arrays.copyOf(this.lastChunk, Math.min(pos << 1, 512));
            this.chunks[this.chunksCount - 1] = this.lastChunk;
        }
        this.lastChunk[pos] = element;
        ++this.size;
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    public int getInt(int index) {
        this.rangeCheck(index);
        return this.chunks[index >> 9][index & 0x1FF];
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }

    public int setInt(int index, int element) {
        this.rangeCheck(index);
        int[] chunk = this.chunks[index >> 9];
        int chunkIndex = index & 0x1FF;
        int result = chunk[chunkIndex];
        chunk[chunkIndex] = element;
        return result;
    }

    public int inc(int index) {
        this.rangeCheck(index);
        int[] nArray = this.chunks[index >> 9];
        int n = index & 0x1FF;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return n2;
    }

    public int pinc(int index) {
        this.rangeCheck(index);
        int[] nArray = this.chunks[index >> 9];
        int n = index & 0x1FF;
        int n2 = nArray[n] + 1;
        nArray[n] = n2;
        return n2;
    }

    public PrimitiveIterator.OfInt iterator() {
        return new Itr();
    }

    private class Itr
    implements PrimitiveIterator.OfInt {
        private int pos = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ChunkedIntList.this.size;
        }

        @Override
        public int nextInt() {
            if (this.pos >= ChunkedIntList.this.size) {
                throw new NoSuchElementException();
            }
            int result = ChunkedIntList.this.chunks[this.pos >> 9][this.pos & 0x1FF];
            ++this.pos;
            return result;
        }
    }
}

