/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public class CollectionsComparator<T>
implements Comparator<Iterable<T>> {
    private static final long serialVersionUID = 0L;
    private static final CollectionsComparator<Comparable<Object>> INSTANCE = new CollectionsComparator(Comparator.naturalOrder());
    private final Comparator<? super T> comparator;

    public CollectionsComparator(Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    public static boolean startsWith(Iterable<?> lhs, Iterable<?> rhs) {
        return CollectionsComparator.startsWith(lhs.iterator(), rhs.iterator());
    }

    public static boolean startsWith(Iterator<?> lhs, Iterator<?> rhs) {
        while (lhs.hasNext() && rhs.hasNext()) {
            if (Objects.equals(lhs.next(), rhs.next())) continue;
            return false;
        }
        return Boolean.compare(lhs.hasNext(), rhs.hasNext()) >= 0;
    }

    public static <T extends Comparable<? super T>> CollectionsComparator<T> naturalOrder() {
        return INSTANCE;
    }

    @Override
    public int compare(Iterable<T> lhs, Iterable<T> rhs) {
        return this.compare(lhs.iterator(), rhs.iterator());
    }

    @Override
    public int compare(Iterator<T> lhs, Iterator<T> rhs) {
        while (lhs.hasNext() && rhs.hasNext()) {
            int cmp = this.comparator.compare(lhs.next(), rhs.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return Boolean.compare(lhs.hasNext(), rhs.hasNext());
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CollectionsComparator && this.comparator.equals(((CollectionsComparator)o).comparator);
    }
}

