/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.BitSet;
import ru.yandex.collection.IntIntervalIterator;
import ru.yandex.collection.IntSet;

public class IntInterval
implements Comparable<IntInterval>,
IntSet {
    private static final int HASH_ROTATE = 13;
    private final int min;
    private final int max;

    public IntInterval(int min, int max) {
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("Interval start must be not greater than interval end: " + this);
        }
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    public IntInterval mergeIfOverlaps(IntInterval other) {
        IntInterval result = null;
        result = this.min <= other.min ? (this.max >= other.max ? this : (this.max + 1 >= other.min ? new IntInterval(this.min, other.max) : null)) : (this.max <= other.max ? other : (this.min - 1 <= other.max ? new IntInterval(other.min, this.max) : null));
        return result;
    }

    @Override
    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public int compareTo(IntInterval other) {
        int cmp = Integer.compare(this.min, other.min);
        if (cmp == 0) {
            cmp = Integer.compare(this.max, other.max);
        }
        return cmp;
    }

    @Override
    public IntIntervalIterator iterator() {
        return new IntIntervalIterator(this.min, this.max);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.min);
        sb.append('-');
        sb.append(this.max);
        return new String(sb);
    }

    public int hashCode() {
        return Integer.rotateLeft(this.min, 13) ^ this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof IntInterval) {
            IntInterval other = (IntInterval)o;
            return this.min == other.min && this.max == other.max;
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.max + 1);
        this.toBitSet(bitSet);
        return bitSet;
    }

    public void toBitSet(BitSet bitSet) {
        bitSet.set(this.min, this.max + 1);
    }
}

