/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ru.yandex.collection.EmptyIntSet;
import ru.yandex.collection.IntInterval;
import ru.yandex.collection.IntSet;
import ru.yandex.function.PrimitiveIterator;

public class IntIntervalSet
implements IntSet {
    private final IntInterval[] intervals;

    protected IntIntervalSet(IntInterval[] intervals) {
        this.intervals = intervals;
    }

    public static IntSet create(BitSet bitSet) {
        int start;
        ArrayList<IntInterval> intervals = new ArrayList<IntInterval>();
        int end = -1;
        while ((start = bitSet.nextSetBit(end + 1)) != -1) {
            end = bitSet.nextClearBit(start + 1);
            intervals.add(new IntInterval(start, end - 1));
        }
        return IntIntervalSet.create(intervals);
    }

    public static IntSet create(List<IntInterval> intervals) {
        IntSet intSet;
        if (intervals.isEmpty()) {
            intSet = EmptyIntSet.INSTANCE;
        } else {
            ArrayList<IntInterval> result = new ArrayList<IntInterval>(intervals.size());
            Collections.sort(intervals);
            Iterator<IntInterval> iter = intervals.iterator();
            IntInterval current = iter.next();
            while (iter.hasNext()) {
                IntInterval next = iter.next();
                IntInterval merged = current.mergeIfOverlaps(next);
                if (merged == null) {
                    result.add(current);
                    current = next;
                    continue;
                }
                current = merged;
            }
            if (result.isEmpty()) {
                intSet = current;
            } else {
                result.add(current);
                intSet = new IntIntervalSet(result.toArray(new IntInterval[result.size()]));
            }
        }
        return intSet;
    }

    @Override
    public int min() {
        return this.intervals[0].min();
    }

    @Override
    public int max() {
        return this.intervals[this.intervals.length - 1].max();
    }

    @Override
    public boolean contains(int value) {
        int from = 0;
        int to = this.intervals.length - 1;
        while (from <= to) {
            int i = from + to >>> 1;
            IntInterval interval = this.intervals[i];
            if (interval.min() > value) {
                to = i - 1;
                continue;
            }
            if (interval.max() < value) {
                from = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new Itr(this.intervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.intervals[0].min());
        sb.append('-');
        sb.append(this.intervals[0].max());
        for (int i = 1; i < this.intervals.length; ++i) {
            sb.append(',');
            sb.append(this.intervals[i].min());
            sb.append('-');
            sb.append(this.intervals[i].max());
        }
        return new String(sb);
    }

    public int hashCode() {
        return Arrays.hashCode(this.intervals);
    }

    public boolean equals(Object o) {
        if (o instanceof IntIntervalSet) {
            return Arrays.equals(this.intervals, ((IntIntervalSet)o).intervals);
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.max() + 1);
        for (IntInterval interval : this.intervals) {
            interval.toBitSet(bitSet);
        }
        return bitSet;
    }

    private static class Itr
    implements PrimitiveIterator.OfInt {
        private final IntInterval[] intervals;
        private int pos = 1;
        private PrimitiveIterator.OfInt current;

        Itr(IntInterval[] intervals) {
            this.intervals = intervals;
            this.current = intervals[0].iterator();
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext();
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                int next = this.current.nextInt();
                if (!this.current.hasNext() && this.pos < this.intervals.length) {
                    this.current = this.intervals[this.pos++].iterator();
                }
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

