/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class IntList
extends AbstractList<Integer> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int[] EMPTY_DATA = new int[0];
    private int size = 0;
    private int[] data;
    private boolean shrinked;

    public IntList() {
        this(0);
    }

    public IntList(int initialCapacity) {
        this.data = initialCapacity <= 0 ? EMPTY_DATA : new int[initialCapacity];
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(index + " >= " + this.size);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.size) {
            this.size = Math.max(newSize, 0);
            this.shrinked = true;
        } else {
            int len = this.data.length;
            if (this.shrinked) {
                Arrays.fill(this.data, this.size, len, 0);
                this.shrinked = false;
            }
            if (newSize > len) {
                this.data = Arrays.copyOf(this.data, Math.max(len << 1, newSize));
            }
            this.size = newSize;
        }
    }

    public void shrink() {
        if (this.size < this.data.length) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        this.data = EMPTY_DATA;
        this.shrinked = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    public int getInt(int index) {
        this.rangeCheck(index);
        return this.data[index];
    }

    @Override
    public boolean add(Integer element) {
        return this.addInt(element);
    }

    public boolean addInt(int element) {
        if (this.size == this.data.length) {
            this.data = this.size <= 0 ? new int[16] : Arrays.copyOf(this.data, this.size << 1);
        }
        this.data[this.size++] = element;
        return true;
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }

    public int setInt(int index, int element) {
        this.rangeCheck(index);
        int result = this.data[index];
        this.data[index] = element;
        return result;
    }

    @Override
    public Integer remove(int index) {
        return this.removeInt(index);
    }

    public int removeInt(int index) {
        this.rangeCheck(index);
        int result = this.data[index];
        System.arraycopy(this.data, index + 1, this.data, index, --this.size - index);
        return result;
    }

    public PrimitiveIterator.OfInt iterator() {
        return new Itr();
    }

    private class Itr
    implements PrimitiveIterator.OfInt {
        private int pos = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < IntList.this.size;
        }

        @Override
        public int nextInt() {
            if (this.pos >= IntList.this.size) {
                throw new NoSuchElementException();
            }
            return IntList.this.data[this.pos++];
        }
    }
}

