/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class Iterators {
    private static final int DEFAULT_LIST_CAPACITY = 4;
    private static final List<Integer> PRIMES = Collections.unmodifiableList(Arrays.asList(51448351, 51448357, 51448361, 51448363, 51448367, 51448373, 51448379, 51448381, 51448387, 51448391, 51448393));

    private Iterators() {
    }

    public static <T> Iterator<T> randomIterator(final List<? extends T> items, int seedValue) {
        if (items.isEmpty()) {
            return Collections.emptyIterator();
        }
        final int seed = seedValue >= 0 ? seedValue : ~seedValue;
        final int size = items.size();
        final int shift = PRIMES.get(seed % PRIMES.size()) % size;
        return new Iterator<T>(){
            private int left;
            private int next;
            {
                this.left = size;
                this.next = seed % size;
            }

            @Override
            public boolean hasNext() {
                return this.left > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object value = items.get(this.next);
                --this.left;
                this.next += shift;
                if (this.next >= size) {
                    this.next -= size;
                }
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        return Iterators.toList(iterator, 4);
    }

    public static <T> List<T> toList(Iterator<? extends T> iterator, int capacity) {
        ArrayList<T> result = new ArrayList<T>(capacity);
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static boolean equals(Iterator<?> lhs, Iterator<?> rhs) {
        while (lhs.hasNext() && rhs.hasNext()) {
            if (Objects.equals(lhs.next(), rhs.next())) continue;
            return false;
        }
        return lhs.hasNext() == rhs.hasNext();
    }
}

