/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.util.AbstractList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import ru.yandex.collection.LazyIterator;

public class LazyList<T, R>
extends AbstractList<R> {
    private final List<? extends T> list;
    private final Function<? super T, ? extends R> function;

    public LazyList(List<? extends T> list, Function<? super T, ? extends R> function) {
        this.list = list;
        this.function = function;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public LazyIterator<T, R> iterator() {
        return new LazyIterator<T, R>(this.list.iterator(), this.function);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public R get(int i) {
        return this.function.apply(this.list.get(i));
    }

    public void rotate(int distance) {
        int dist = distance % this.size();
        if (dist == 0) {
            return;
        }
        if (this.list instanceof LinkedList) {
            int mid = dist >> 1;
            LinkedList linkedList = (LinkedList)this.list;
            if (dist <= mid) {
                for (int i = 0; i < dist; ++i) {
                    linkedList.addFirst(linkedList.removeLast());
                }
            } else {
                for (int i = 0; i < dist; ++i) {
                    linkedList.addLast(linkedList.removeFirst());
                }
            }
        } else {
            Collections.rotate(this.list, dist);
        }
    }
}

