/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PatternMapper<T> {
    public static final String ASTERISK = "*";
    private final Map<String, T> exact = new HashMap<String, T>();
    private final Map<String, T> prefix = new TreeMap<String, T>(new StringLengthComparator());
    private T asterisk;

    public PatternMapper() {
        this(null);
    }

    public PatternMapper(T asterisk) {
        this.asterisk = asterisk;
    }

    public T put(String pattern, T obj) {
        T result;
        if (pattern.equals(ASTERISK)) {
            result = this.asterisk;
            this.asterisk = obj;
        } else {
            result = pattern.charAt(pattern.length() - 1) == '*' ? this.prefix.put(pattern.substring(0, pattern.length() - 1), obj) : this.exact.put(pattern, obj);
        }
        return result;
    }

    public T remove(String pattern) {
        T result;
        if (pattern.equals(ASTERISK)) {
            result = this.asterisk;
            this.asterisk = null;
        } else {
            result = pattern.charAt(pattern.length() - 1) == '*' ? this.prefix.remove(pattern.substring(0, pattern.length() - 1)) : this.exact.remove(pattern);
        }
        return result;
    }

    public T get(String uri) {
        T result = this.exact.get(uri);
        if (result == null) {
            for (Map.Entry<String, T> entry : this.prefix.entrySet()) {
                if (!uri.startsWith(entry.getKey())) continue;
                result = entry.getValue();
                break;
            }
            if (result == null) {
                result = this.asterisk;
            }
        }
        return result;
    }

    public T get(String ... uries) {
        T result = null;
        block0: for (int i = 0; i < uries.length && result == null; ++i) {
            String uri = uries[i];
            result = this.exact.get(uri);
            if (result != null) continue;
            for (Map.Entry<String, T> entry : this.prefix.entrySet()) {
                if (!uri.startsWith(entry.getKey())) continue;
                result = entry.getValue();
                continue block0;
            }
        }
        if (result == null) {
            result = this.asterisk;
        }
        return result;
    }

    public Map<String, T> exact() {
        return Collections.unmodifiableMap(this.exact);
    }

    public Map<String, T> prefix() {
        return Collections.unmodifiableMap(this.prefix);
    }

    public T asterisk() {
        return this.asterisk;
    }

    public <U, E extends Exception> PatternMapper<U> transform(Transformer<? super T, ? extends U, E> transformer) throws E {
        PatternMapper<T> mapper = new PatternMapper<T>();
        for (Map.Entry<String, T> entry : this.exact.entrySet()) {
            mapper.exact.put(entry.getKey(), transformer.transform(entry.getValue()));
        }
        for (Map.Entry<String, T> entry : this.prefix.entrySet()) {
            mapper.prefix.put(entry.getKey(), transformer.transform(entry.getValue()));
        }
        if (this.asterisk != null) {
            mapper.asterisk = transformer.transform(this.asterisk);
        }
        return mapper;
    }

    public <U, E extends Exception> PatternMapper<U> transform(EntryTransformer<? super T, ? extends U, E> transformer) throws E {
        PatternMapper<T> mapper = new PatternMapper<T>();
        for (Map.Entry<String, T> entry : this.exact.entrySet()) {
            mapper.exact.put(entry.getKey(), transformer.transform(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, T> entry : this.prefix.entrySet()) {
            mapper.prefix.put(entry.getKey(), transformer.transform(entry.getKey() + '*', entry.getValue()));
        }
        if (this.asterisk != null) {
            mapper.asterisk = transformer.transform(ASTERISK, this.asterisk);
        }
        return mapper;
    }

    public <E extends Exception> void traverse(EntryVisitor<? super T, E> visitor) throws E {
        for (Map.Entry<String, T> entry : this.exact.entrySet()) {
            visitor.visit(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, T> entry : this.prefix.entrySet()) {
            visitor.visit(entry.getKey() + '*', entry.getValue());
        }
        if (this.asterisk != null) {
            visitor.visit(ASTERISK, this.asterisk);
        }
    }

    private static class StringLengthComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private StringLengthComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            int result = Integer.compare(rhs.length(), lhs.length());
            if (result == 0) {
                result = lhs.compareTo(rhs);
            }
            return result;
        }
    }

    public static interface EntryVisitor<T, E extends Exception> {
        public void visit(String var1, T var2) throws E;
    }

    public static interface EntryTransformer<T, U, E extends Exception> {
        public U transform(String var1, T var2) throws E;
    }

    public static interface Transformer<T, U, E extends Exception> {
        public U transform(T var1) throws E;
    }
}

