/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.function;

import ru.yandex.function.Processable;
import ru.yandex.function.Processor;
import ru.yandex.function.VoidProcessor;

public class BasicProcessable<T>
implements Processable<T> {
    protected T buf;
    protected int off;
    protected int len;

    public BasicProcessable(T buf, int off, int len) {
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public <E extends Exception> void processWith(VoidProcessor<? super T, E> processor) throws E {
        processor.process(this.buf, this.off, this.len);
    }

    @Override
    public <R, E extends Exception> R processWith(Processor<? super T, R, E> processor) throws E {
        return processor.process(this.buf, this.off, this.len);
    }

    @Override
    public int transferTo(T buf, int off, int len) {
        int transferSize = Math.min(len, this.len);
        System.arraycopy(this.buf, this.off, buf, off, transferSize);
        this.off += transferSize;
        this.len -= transferSize;
        return transferSize;
    }

    protected void copyFrom(T buf, int off, int len) {
        System.arraycopy(buf, off, this.buf, 0, len);
        this.off = 0;
        this.len = len;
    }
}

