/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.function;

import ru.yandex.function.FilterProcessable;
import ru.yandex.function.Processable;
import ru.yandex.function.VoidProcessor;

public class StringBuilderVoidProcessor<T, E extends Exception>
extends FilterProcessable<T>
implements VoidProcessor<StringBuilder, E> {
    private static final char[] EMPTY_BUF = new char[0];
    private final VoidProcessor<? super char[], ? extends E> processor;
    private char[] buf = EMPTY_BUF;

    public <U extends Processable<T> & VoidProcessor<? super char[], ? extends E>> StringBuilderVoidProcessor(U u) {
        this(u, (VoidProcessor<? super char[], ? extends E>)u);
    }

    private StringBuilderVoidProcessor(Processable<T> processable, VoidProcessor<? super char[], ? extends E> processor) {
        super(processable);
        this.processor = processor;
    }

    @Override
    public void process(StringBuilder str) throws E {
        this.process(str, 0, str.length());
    }

    @Override
    public void process(StringBuilder str, int off, int len) throws E {
        if (this.buf.length < len) {
            this.buf = new char[Math.max(len, this.buf.length << 1)];
        }
        str.getChars(off, off + len, this.buf, 0);
        this.processor.process((char[])this.buf, 0, len);
    }
}

