/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.Reader;
import ru.yandex.function.GenericAutoCloseableChain;
import ru.yandex.io.GenericCloseableAdapter;

public class ChainedReader
extends Reader {
    private final Reader[] readers;
    private int pos = 0;

    public ChainedReader(Reader ... readers) {
        this.readers = readers;
    }

    @Override
    public void close() throws IOException {
        try (GenericAutoCloseableChain<IOException> chain = new GenericAutoCloseableChain<IOException>();){
            for (Reader reader : this.readers) {
                chain.add(new GenericCloseableAdapter<Reader>(reader));
            }
        }
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        while (this.pos < this.readers.length) {
            int read = this.readers[this.pos].read(buf, off, len);
            if (read == -1) {
                ++this.pos;
                continue;
            }
            return read;
        }
        return -1;
    }
}

