/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 65536;
    protected long pos = 0L;
    private final InputStream in;
    private boolean open = true;

    public CountingInputStream(InputStream in) {
        this.in = in;
    }

    public long pos() {
        return this.pos;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            byte[] buf = new byte[65536];
            int read = this.read(buf);
            while (read != -1) {
                read = this.read(buf);
            }
            this.in.close();
        }
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            ++this.pos;
        }
        return read;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int read = this.in.read(buf, off, len);
        if (read != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.pos += skip;
        return skip;
    }
}

