/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;

public class CountingWriter
extends Writer {
    private static final String NULL = "null";
    private final Writer writer;
    private long pos = 0L;

    public CountingWriter(Writer writer) {
        this.writer = writer;
    }

    public long pos() {
        return this.pos;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.writer.append(c);
        ++this.pos;
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            return this.append(NULL);
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            return this.append(NULL);
        }
        this.writer.append(csq, start, end);
        this.pos += (long)(end - start);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        this.pos += (long)len;
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
        ++this.pos;
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
        this.pos += (long)len;
    }
}

