/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import ru.yandex.function.ByteArrayVoidProcessor;
import ru.yandex.function.Processable;
import ru.yandex.function.Processor;
import ru.yandex.function.VoidProcessor;

public class DecodableByteArrayOutputStream
extends OutputStream
implements Processable<byte[]>,
ByteArrayVoidProcessor<RuntimeException> {
    private static final int DEFAULT_SIZE = 1024;
    private static final byte[] EMPTY_BUF = new byte[0];
    private int len = 0;
    private byte[] buf;

    public DecodableByteArrayOutputStream() {
        this(1024);
    }

    public DecodableByteArrayOutputStream(int size) {
        this.buf = size == 0 ? EMPTY_BUF : new byte[size];
    }

    private void ensureCapacity(int size) {
        if (size > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(size, this.len << 1));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int newLen = this.len + len;
        this.ensureCapacity(newLen);
        System.arraycopy(b, off, this.buf, this.len, len);
        this.len = newLen;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.len + 1);
        this.buf[this.len++] = (byte)b;
    }

    public void write(ByteBuffer bb) {
        int rem = bb.remaining();
        this.ensureCapacity(this.len + rem);
        bb.get(this.buf, this.len, rem);
        this.len += rem;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public int length() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public boolean copylessToByteArray() {
        return this.len == this.buf.length;
    }

    public byte[] toByteArray() {
        if (this.copylessToByteArray()) {
            return this.buf;
        }
        return Arrays.copyOf(this.buf, this.len);
    }

    public int count(byte b) {
        int count = 0;
        for (int i = 0; i < this.len; ++i) {
            if (this.buf[i] != b) continue;
            ++count;
        }
        return count;
    }

    @Override
    public <E extends Exception> void processWith(VoidProcessor<? super byte[], E> processor) throws E {
        processor.process((byte[])this.buf, 0, this.len);
    }

    @Override
    public <R, E extends Exception> R processWith(Processor<? super byte[], R, E> processor) throws E {
        return processor.process((byte[])this.buf, 0, this.len);
    }

    @Override
    public void process(byte[] buf, int off, int len) {
        this.write(buf, off, len);
    }

    @Override
    public int transferTo(byte[] buf, int off, int len) {
        int transferSize = Math.min(len, this.len);
        System.arraycopy(this.buf, 0, buf, off, transferSize);
        this.len -= transferSize;
        System.arraycopy(this.buf, transferSize, this.buf, 0, len);
        return transferSize;
    }
}

