/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class DecodingInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 4096;
    protected final byte[] buf = new byte[4096];
    protected final InputStream in;
    protected int buflen = 0;
    protected int pos = 0;

    public DecodingInputStream(InputStream in) {
        this.in = in;
    }

    protected abstract void fillBuffer() throws IOException;

    @Override
    public int available() throws IOException {
        return this.buflen - this.pos;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.buflen) {
            this.fillBuffer();
            if (this.pos >= this.buflen) {
                return -1;
            }
        }
        return this.buf[this.pos++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.buflen) {
            this.fillBuffer();
            if (this.pos >= this.buflen) {
                return -1;
            }
        }
        int transfer = Math.min(this.buflen - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, transfer);
        this.pos += transfer;
        return transfer;
    }
}

