/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FsyncingFileOutputStream
extends FileOutputStream {
    private final int fsyncThreshold;
    private int written = 0;

    public FsyncingFileOutputStream(File file, boolean append, int fsyncThreshold) throws FileNotFoundException {
        super(file, append);
        this.fsyncThreshold = fsyncThreshold;
    }

    private void fsync(boolean metadata) throws IOException {
        this.getChannel().force(metadata);
    }

    private void written(int count) throws IOException {
        this.written += count;
        if (this.written >= this.fsyncThreshold) {
            this.written = 0;
            this.fsync(false);
        }
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.written(1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.written(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.written(len);
    }
}

