/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import ru.yandex.util.string.HexStrings;

public class HexOutputStream
extends OutputStream {
    private final Writer writer;
    private final char[] hex;

    public HexOutputStream(Writer writer, HexStrings hex) {
        this.writer = writer;
        this.hex = hex.chars();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(buf[i + off]);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(this.hex[b >>> 4 & 0xF]);
        this.writer.write(this.hex[b & 0xF]);
    }
}

