/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import ru.yandex.io.DecodableByteArrayOutputStream;

public final class IOStreamUtils {
    private static final int BUFFER_SIZE = 4096;

    private IOStreamUtils() {
    }

    public static void skipTo(InputStream in, byte[] mark) throws IOException {
        int read;
        byte[] buf = new byte[mark.length];
        int len = 0;
        while (len < buf.length) {
            read = in.read();
            if (read == -1) {
                throw new EOFException("Stream is shorter than skip mark");
            }
            buf[len++] = (byte)read;
        }
        while (!Arrays.equals(buf, mark)) {
            read = in.read();
            if (read == -1) {
                throw new EOFException("Skip mark not found");
            }
            for (int i = 1; i < buf.length; ++i) {
                buf[i - 1] = buf[i];
            }
            buf[buf.length - 1] = (byte)read;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    public static int peek(InputStream in, byte[] buf) throws IOException {
        int left;
        int pos = 0;
        try (Resetter resetter = new Resetter(in, left);){
            int read;
            for (left = buf.length; left != 0; left -= read) {
                read = in.read(buf, pos, left);
                if (read == -1) {
                    break;
                }
                pos += read;
            }
        }
        return pos;
    }

    public static StringBuilder consume(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        IOStreamUtils.consume(reader, sb);
        return sb;
    }

    public static void consume(Reader reader, StringBuilder sb) throws IOException {
        int read;
        char[] buf = new char[4096];
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
    }

    public static DecodableByteArrayOutputStream consume(InputStream in) throws IOException {
        DecodableByteArrayOutputStream out = new DecodableByteArrayOutputStream();
        IOStreamUtils.copy(in, out);
        return out;
    }

    private static class Resetter
    implements Closeable {
        private final InputStream in;

        Resetter(InputStream in, int len) {
            this.in = in;
            in.mark(len);
        }

        @Override
        public void close() throws IOException {
            this.in.reset();
        }
    }
}

