/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;
import ru.yandex.io.CountingInputStream;

public class LimitedInputStream
extends CountingInputStream {
    private final long limit;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), (int)Math.min(this.limit - this.pos, Integer.MAX_VALUE));
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.limit) {
            return super.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        long left = this.limit - this.pos;
        if (left == 0L) {
            return -1;
        }
        int toRead = left < (long)len ? (int)left : len;
        return super.read(buf, off, toRead);
    }
}

