/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import ru.yandex.io.CountingOutputStream;
import ru.yandex.io.LimitedIOException;

public class LimitedOutputStream
extends CountingOutputStream {
    private final long limit;

    public LimitedOutputStream(OutputStream out, long limit) {
        super(out);
        this.limit = limit;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= this.limit) {
            throw new LimitedIOException();
        }
        super.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        long overrun = this.pos + (long)len - this.limit;
        if (overrun > 0L) {
            super.write(buf, off, len - (int)overrun);
            throw new LimitedIOException();
        }
        super.write(buf, off, len);
    }
}

