/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;
import ru.yandex.io.LimitedIOException;

public class LimitedWriter
extends Writer {
    private final Writer writer;
    private final long limit;
    private long pos = 0L;

    public LimitedWriter(Writer writer, long limit) {
        this.writer = writer;
        this.limit = limit;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        long overrun = this.pos + (long)len - this.limit;
        if (overrun > 0L) {
            this.writer.write(buf, off, len - (int)overrun);
            throw new LimitedIOException();
        }
        this.writer.write(buf, off, len);
        this.pos += (long)len;
    }
}

