/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;
import ru.yandex.io.DecodingInputStream;
import ru.yandex.io.MalformedQuotedPrintableException;

public class QuotedPrintableInputStream
extends DecodingInputStream {
    private static final int SHIFT = 4;
    private static final byte[] TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public QuotedPrintableInputStream(InputStream in) {
        super(in);
    }

    protected void malformed(int read, int c1, int c2) throws IOException {
        throw new MalformedQuotedPrintableException("Malformed char codes after equal sign: " + c1 + ',' + ' ' + c2);
    }

    protected int doRead() throws IOException {
        return this.in.read(this.buf);
    }

    @Override
    protected void fillBuffer() throws IOException {
        int read;
        block2: do {
            read = this.doRead();
            this.pos = 0;
            while (this.pos < read && this.buf[this.pos] != 61) {
                ++this.pos;
            }
            this.buflen = this.pos;
            while (this.pos < read) {
                int c2;
                int c1;
                if (++this.pos < read) {
                    c1 = this.buf[this.pos++];
                    c2 = this.pos < read ? this.buf[this.pos++] : this.in.read();
                } else {
                    c1 = this.in.read();
                    c2 = this.in.read();
                }
                if (c1 == 13) {
                    if (c2 != 10) {
                        this.malformed(read, c1, c2);
                        continue block2;
                    }
                } else {
                    int lower;
                    int upper;
                    try {
                        upper = TABLE[c1];
                        lower = TABLE[c2];
                    }
                    catch (RuntimeException e) {
                        upper = -1;
                        lower = -1;
                    }
                    if (upper >= 0 && lower >= 0) {
                        this.buf[this.buflen++] = (byte)((upper << 4) + lower);
                    } else {
                        this.malformed(read, c1, c2);
                        continue block2;
                    }
                }
                while (this.pos < read && this.buf[this.pos] != 61) {
                    this.buf[this.buflen++] = this.buf[this.pos++];
                }
            }
        } while (this.pos == read && this.buflen == 0);
        this.pos = 0;
    }
}

