/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import ru.yandex.io.TaggedIOException;

public class TaggedInputStream
extends InputStream {
    private final InputStream in;
    private final Serializable tag;

    public TaggedInputStream(InputStream in) {
        this(in, TaggedIOException.createTag());
    }

    public TaggedInputStream(InputStream in, Serializable tag) {
        this.in = in;
        this.tag = tag;
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return this.in.read(b);
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.in.skip(n);
        }
        catch (IOException e) {
            throw new TaggedIOException(this.tag, e);
        }
    }

    public boolean isCauseOf(IOException e) {
        return e instanceof TaggedIOException && this.tag == ((TaggedIOException)e).tag();
    }

    public void throwIfCauseOf(IOException e) throws IOException {
        TaggedIOException tagged;
        if (e instanceof TaggedIOException && this.tag == (tagged = (TaggedIOException)e).tag()) {
            throw tagged.getCause();
        }
    }
}

