/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import ru.yandex.io.ExceptionHandlingOutputStream;
import ru.yandex.io.TaggedIOException;

public class TaggedOutputStream
extends ExceptionHandlingOutputStream {
    private final Serializable tag;

    public TaggedOutputStream(OutputStream out) {
        this(out, TaggedIOException.createTag());
    }

    public TaggedOutputStream(OutputStream out, Serializable tag) {
        super(out);
        this.tag = tag;
    }

    public boolean isCauseOf(IOException e) {
        return e instanceof TaggedIOException && this.tag == ((TaggedIOException)e).tag();
    }

    @Override
    protected void handleException(IOException e) throws IOException {
        throw new TaggedIOException(this.tag, e);
    }
}

