/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.io;

import java.io.IOException;
import java.io.Writer;

public class TrimmingWriter
extends Writer {
    private static final int VTAB = 11;
    private static final int FF = 12;
    private static final int CR = 12;
    private final StringBuilder sb = new StringBuilder();
    private final Writer writer;
    private boolean empty = true;
    private boolean firstLine = true;
    private boolean lineStart = true;
    private boolean spaces = true;

    public TrimmingWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(int ch) throws IOException {
        char c = (char)ch;
        if (c == '\n') {
            if (this.firstLine && !this.empty) {
                this.firstLine = false;
            }
            this.lineStart = true;
            this.spaces = true;
            this.sb.setLength(0);
        } else if (c <= ' ' || c == '\u00a0') {
            if (!this.spaces) {
                this.spaces = true;
                this.sb.append(c);
            }
        } else {
            if (this.lineStart && !this.firstLine) {
                this.writer.write(10);
            }
            if (this.sb.length() > 0) {
                this.writer.append(this.sb);
                this.sb.setLength(0);
            }
            this.lineStart = false;
            this.empty = false;
            this.spaces = false;
            this.writer.write(ch);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[i + off]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

