/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jniwrapper;

import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractJniWrapperConfigBuilder<T extends AbstractJniWrapperConfigBuilder<T>>
implements JniWrapperConfig {
    private String libraryName;
    private String ctorName;
    private String dtorName;
    private String mainName;
    private String logrotateName;
    private String freeName;
    private String config;
    private boolean threadSafe;

    public AbstractJniWrapperConfigBuilder(JniWrapperConfig config) {
        this.libraryName(config.libraryName());
        this.ctorName(config.ctorName());
        this.dtorName(config.dtorName());
        this.mainName(config.mainName());
        this.logrotateName(config.logrotateName());
        this.freeName(config.freeName());
        this.config(config.config());
        this.threadSafe(config.threadSafe());
    }

    public AbstractJniWrapperConfigBuilder(IniConfig config, JniWrapperConfig defaults) throws ConfigException {
        this.libraryName = LIBRARY_NAME.extract(config, defaults.libraryName());
        this.ctorName = CTOR_NAME.extract(config, defaults.ctorName());
        this.dtorName = DTOR_NAME.extract(config, defaults.dtorName());
        this.mainName = MAIN_NAME.extract(config, defaults.mainName());
        this.logrotateName = LOGROTATE_NAME.extract(config, defaults.logrotateName());
        this.freeName = FREE_NAME.extract(config, defaults.freeName());
        this.config = config.getString("config", defaults.config());
        this.threadSafe = config.getBoolean("thread-safe", defaults.threadSafe());
    }

    protected abstract T self();

    @Override
    public String libraryName() {
        return this.libraryName;
    }

    public T libraryName(String libraryName) {
        this.libraryName = libraryName;
        return this.self();
    }

    @Override
    public String ctorName() {
        return this.ctorName;
    }

    public T ctorName(String ctorName) {
        this.ctorName = ctorName;
        return this.self();
    }

    @Override
    public String dtorName() {
        return this.dtorName;
    }

    public T dtorName(String dtorName) {
        this.dtorName = dtorName;
        return this.self();
    }

    @Override
    public String mainName() {
        return this.mainName;
    }

    public T mainName(String mainName) {
        this.mainName = mainName;
        return this.self();
    }

    @Override
    public String logrotateName() {
        return this.logrotateName;
    }

    public T logrotateName(String logrotateName) {
        this.logrotateName = logrotateName;
        return this.self();
    }

    @Override
    public String freeName() {
        return this.freeName;
    }

    public T freeName(String freeName) {
        this.freeName = freeName;
        return this.self();
    }

    @Override
    public String config() {
        return this.config;
    }

    public T config(String config) {
        this.config = config;
        return this.self();
    }

    @Override
    public boolean threadSafe() {
        return this.threadSafe;
    }

    public T threadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
        return this.self();
    }
}

