/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jniwrapper;

import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import ru.yandex.function.ByteArrayProcessor;
import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.function.Processor;
import ru.yandex.io.IOStreamUtils;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.jniwrapper.JniWrapperUnprocessableInputException;
import ru.yandex.jniwrapper.ThreadLocalJniWrapper;
import ru.yandex.jniwrapper.ThreadSafeJniWrapper;
import ru.yandex.parser.config.IniConfig;

public abstract class JniWrapper
implements BiFunction<String, String, Processor<byte[], String, JniWrapperException>>,
GenericAutoCloseable<RuntimeException> {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String config;
    private final long handle;

    public JniWrapper(ImmutableJniWrapperConfig config) throws JniWrapperException {
        this.config = config.config();
        try {
            this.handle = JniWrapper.load(config.libraryName(), config.ctorName(), config.dtorName(), config.mainName(), config.logrotateName(), config.freeName());
        }
        catch (RuntimeException e) {
            throw new JniWrapperException("Failed to load library " + config.libraryName() + '(' + config.ctorName() + ',' + config.dtorName() + ',' + config.mainName() + ',' + config.logrotateName() + ',' + config.freeName() + ')', e);
        }
    }

    public static JniWrapper create(ImmutableJniWrapperConfig config) throws JniWrapperException {
        if (config.threadSafe()) {
            return new ThreadSafeJniWrapper(config);
        }
        return new ThreadLocalJniWrapper(config);
    }

    private static native long load(String var0, String var1, String var2, String var3, String var4, String var5);

    private static native void unload(long var0);

    private static native long createInstance(long var0, String var2);

    protected long createInstance() throws JniWrapperException {
        try {
            return JniWrapper.createInstance(this.handle, this.config);
        }
        catch (RuntimeException e) {
            throw new JniWrapperException(e);
        }
    }

    private static native void destroyInstance(long var0, long var2);

    protected void destroyInstance(long instance) {
        JniWrapper.destroyInstance(this.handle, instance);
    }

    private static native String process(long var0, long var2, String var4, String var5, byte[] var6, int var7, int var8);

    public abstract void logrotate();

    private static native void logrotate(long var0, long var2);

    protected void logrotate(long instance) {
        JniWrapper.logrotate(this.handle, instance);
    }

    protected abstract long getInstance() throws JniWrapperException;

    protected void onClose() {
        JniWrapper.unload(this.handle);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.onClose();
        }
    }

    @Override
    public Processor<byte[], String, JniWrapperException> apply(String uri, String metainfo) {
        return new JniProcessor(uri, metainfo);
    }

    private static String getOrDefault(String[] args, int idx, String defaultValue) {
        if (idx >= args.length) {
            return defaultValue;
        }
        return args[idx];
    }

    public static void main(String ... args) throws Exception {
        System.out.print(IOStreamUtils.consume(System.in).processWith(JniWrapper.create(new ImmutableJniWrapperConfig(new JniWrapperConfigBuilder(new IniConfig(Paths.get(args[0], new String[0]))))).apply(JniWrapper.getOrDefault(args, 1, ""), JniWrapper.getOrDefault(args, 2, null))));
    }

    static {
        System.loadLibrary("jniwrapper-main");
    }

    public class JniProcessor
    implements ByteArrayProcessor<String, JniWrapperException> {
        private final String uri;
        private final String metainfo;

        public JniProcessor(String uri, String metainfo) {
            this.uri = uri;
            this.metainfo = metainfo;
        }

        @Override
        public String process(byte[] buf, int off, int len) throws JniWrapperException {
            long instance = JniWrapper.this.getInstance();
            try {
                return JniWrapper.process(JniWrapper.this.handle, instance, this.uri, this.metainfo, buf, off, len);
            }
            catch (IllegalArgumentException e) {
                throw new JniWrapperUnprocessableInputException(e);
            }
            catch (RuntimeException e) {
                throw new JniWrapperException(e);
            }
        }
    }
}

