/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jniwrapper;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperException;

public class ThreadLocalJniWrapper
extends JniWrapper {
    private final ThreadLocal<Instance> instance = new ThreadLocal();
    private final Map<Instance, Instance> instances = new IdentityHashMap<Instance, Instance>();

    public ThreadLocalJniWrapper(ImmutableJniWrapperConfig config) throws JniWrapperException {
        super(config);
        this.destroyInstance(this.createInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getInstance() throws JniWrapperException {
        Instance instance = this.instance.get();
        if (instance == null) {
            instance = new Instance(this.createInstance());
            ThreadLocalJniWrapper threadLocalJniWrapper = this;
            synchronized (threadLocalJniWrapper) {
                this.instances.put(instance, instance);
            }
            this.instance.set(instance);
        }
        return instance.ptr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        ArrayList<Instance> instances;
        ThreadLocalJniWrapper threadLocalJniWrapper = this;
        synchronized (threadLocalJniWrapper) {
            instances = new ArrayList<Instance>(this.instances.values());
            this.instances.clear();
        }
        for (Instance instance : instances) {
            instance.close();
        }
        super.onClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logrotate() {
        ArrayList<Instance> instances;
        ThreadLocalJniWrapper threadLocalJniWrapper = this;
        synchronized (threadLocalJniWrapper) {
            instances = new ArrayList<Instance>(this.instances.values());
        }
        for (Instance instance : instances) {
            instance.logrotate();
        }
    }

    private class Instance
    implements AutoCloseable {
        private final long ptr;
        private boolean closed = false;

        Instance(long ptr) {
            this.ptr = ptr;
        }

        public long ptr() {
            return this.ptr;
        }

        public synchronized void logrotate() {
            if (!this.closed) {
                ThreadLocalJniWrapper.this.logrotate(this.ptr);
            }
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                ThreadLocalJniWrapper.this.destroyInstance(this.ptr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            ThreadLocalJniWrapper threadLocalJniWrapper = ThreadLocalJniWrapper.this;
            synchronized (threadLocalJniWrapper) {
                if (ThreadLocalJniWrapper.this.instances.remove(this) == null) {
                    return;
                }
            }
            this.close();
        }
    }
}

