/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniLoader;
import ru.yandex.parser.config.ParameterNotSetException;
import ru.yandex.parser.string.ValuesStorage;

public class IniConfig
implements ValuesStorage<ConfigException> {
    private final Map<String, String> keys = new LinkedHashMap<String, String>();
    private final Set<String> unusedKeys = new HashSet<String>();
    private final Map<String, IniConfig> sections = new LinkedHashMap<String, IniConfig>();
    private final String prefix;

    public IniConfig(File file) throws ConfigException, IOException {
        this(file.toPath());
    }

    public IniConfig(Path file) throws ConfigException, IOException {
        this.prefix = "";
        new IniLoader(this, file);
    }

    public IniConfig(Reader reader) throws ConfigException, IOException {
        this.prefix = "";
        new IniLoader(this, reader);
    }

    private IniConfig(String prefix) {
        this.prefix = prefix;
    }

    public void put(String key, String value) {
        int idx = key.indexOf(46);
        if (idx == -1) {
            this.keys.put(key, value);
            this.unusedKeys.add(key);
        } else {
            this.section(key.substring(0, idx)).put(key.substring(idx + 1), value);
        }
    }

    public IniConfig sectionOrNull(String section) {
        int idx = section.indexOf(46);
        if (idx == -1) {
            return this.sections.get(section);
        }
        IniConfig subsection = this.sections.get(section.substring(0, idx));
        if (subsection != null) {
            subsection = subsection.sectionOrNull(section.substring(idx + 1));
        }
        return subsection;
    }

    public IniConfig section(String section) {
        IniConfig result = this.sections.get(section);
        if (result == null) {
            int idx = section.indexOf(46);
            if (idx == -1) {
                result = new IniConfig(this.prefix + section + '.');
                this.sections.put(section, result);
            } else {
                result = this.section(section.substring(0, idx)).section(section.substring(idx + 1));
            }
        }
        return result;
    }

    public IniConfig createSection(String section) {
        IniConfig sect = this.sections.get(section);
        if (sect == null) {
            sect = new IniConfig(this.prefix + section + '.');
            this.sections.put(section, sect);
        }
        return sect;
    }

    public Set<String> keys() {
        return this.keys.keySet();
    }

    public Map<String, IniConfig> sections() {
        return this.sections;
    }

    public List<String> unusedKeys() {
        ArrayList<String> unusedKeys = new ArrayList<String>(this.unusedKeys);
        for (Map.Entry<String, IniConfig> entry : this.sections.entrySet()) {
            for (String key : entry.getValue().unusedKeys()) {
                unusedKeys.add(entry.getKey() + '.' + key);
            }
        }
        return unusedKeys;
    }

    public void checkUnusedKeys() throws ConfigException {
        List<String> unusedKeys = this.unusedKeys();
        if (!unusedKeys.isEmpty()) {
            throw new ConfigException("The following configuration keys wasn't used: " + unusedKeys);
        }
    }

    public void renameSection(String from, String to) throws ConfigException {
        if (from.indexOf(46) != -1 || to.indexOf(46) != -1) {
            throw new ConfigException("Nested sections renaming is not supported, can't rename '" + from + "' to '" + to + '\'');
        }
        if (this.sections.containsKey(to)) {
            throw new ConfigException("Renaming '" + from + "' will overwrite existing section '" + to + '\'');
        }
        IniConfig section = this.sections.remove(from);
        if (section == null) {
            this.sections.remove(to);
        } else {
            this.sections.put(to, section);
        }
    }

    @Override
    public String getOrNull(String key) {
        String value;
        int idx = key.lastIndexOf(46);
        if (idx == -1) {
            this.unusedKeys.remove(key);
            value = this.keys.get(key);
        } else {
            IniConfig section = this.sectionOrNull(key.substring(0, idx));
            value = section == null ? null : section.getOrNull(key.substring(idx + 1));
        }
        return value;
    }

    @Override
    public String getLastOrNull(String name) {
        return this.getOrNull(name);
    }

    @Override
    public Iterator<String> getAllOrNull(String name) {
        String value = this.getOrNull(name);
        if (value == null) {
            return null;
        }
        return Collections.singleton(value).iterator();
    }

    @Override
    public ParameterNotSetException parameterNotSetException(String name) {
        return new ParameterNotSetException(this.prefix + name);
    }

    @Override
    public ConfigException parseFailedException(String name, String value, Throwable cause) {
        return new ConfigException("Failed to parse parameter " + this.prefix + name + " with value '" + value + '\'', cause);
    }

    public static void main(String ... args) throws ConfigException, IOException {
        if (args.length < 2) {
            System.err.println("Usage: ru.yandex.parser.config.IniConfig <config file> <parameter name>");
            System.exit(1);
        }
        System.out.println(new IniConfig(args[0]).getString(args[1]));
    }
}

