/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.config;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.yandex.collection.CollectionsComparator;
import ru.yandex.function.StringProcessor;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.util.filesystem.PathUtils;
import ru.yandex.util.string.StringUtils;

public class IniLoader {
    private static final CollectionParser<String, List<String>, RuntimeException> SECTIONS_PARSER = new CollectionParser(x -> x, ArrayList::new, '.');
    private final StringProcessor<List<String>, RuntimeException> sectionsParser = new StringProcessor<List<String>, RuntimeException>(SECTIONS_PARSER);
    private final IniConfig root;
    private final Path configDir;
    private IniConfig current;
    private ConfigException exception = null;

    public IniLoader(IniConfig root, Reader config) throws ConfigException, IOException {
        this.root = root;
        this.configDir = null;
        this.loadConfig(config);
    }

    public IniLoader(IniConfig root, Path config) throws ConfigException, IOException {
        this.root = root;
        this.configDir = config.toAbsolutePath().getParent();
        this.loadConfig(config);
        Path overrides = config.resolveSibling(config.getFileName() + ".overrides");
        if (Files.exists(overrides, new LinkOption[0])) {
            this.loadConfig(overrides);
        }
    }

    private void loadConfig(Reader reader) throws ConfigException, IOException {
        this.current = this.root;
        new Properties(){
            private static final long serialVersionUID = 0L;

            @Override
            public Object put(Object key, Object value) {
                IniLoader.this.processRecord(key.toString(), value.toString());
                return null;
            }
        }.load(reader);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void loadConfig(Path config) throws ConfigException, IOException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(config, new OpenOption[0]), StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));){
            this.loadConfig(reader);
        }
    }

    private void accountException(ConfigException exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            this.exception.addSuppressed(exception);
        }
    }

    private void processSection(String section) {
        this.current = this.root;
        for (String sectionName : this.sectionsParser.process(section)) {
            this.current = this.current.createSection(sectionName);
        }
        if (!this.current.keys().isEmpty()) {
            this.accountException(new ConfigException("Section already exists: " + section));
        }
    }

    private String trimValue(String value) {
        String rawValue = this.isProperty(value) ? value.substring(2, value.length() - 1).trim() : value.trim();
        return rawValue.replaceAll("[ \t]*?", "");
    }

    private long longValue(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.accountException(new ConfigException("Invalid number value " + value + " in property expresion"));
            return 0L;
        }
    }

    private String add(String arg1, String arg2) {
        return Long.toString(this.longValue(this.propertyValue(arg1)) + this.longValue(this.propertyValue(arg2)));
    }

    private String substract(String arg1, String arg2) {
        return Long.toString(this.longValue(this.propertyValue(arg1)) - this.longValue(this.propertyValue(arg2)));
    }

    private String mul(String arg1, String arg2) {
        return Long.toString(this.longValue(this.propertyValue(arg1)) * this.longValue(this.propertyValue(arg2)));
    }

    private String div(String arg1, String arg2) {
        return Long.toString(this.longValue(this.propertyValue(arg1)) / this.longValue(this.propertyValue(arg2)));
    }

    private String remainder(String arg1, String arg2) {
        return Long.toString(this.longValue(this.propertyValue(arg1)) % this.longValue(this.propertyValue(arg2)));
    }

    private boolean isProperty(String value) {
        return value.charAt(0) == '$' && value.charAt(1) == '(' && value.charAt(value.length() - 1) == ')';
    }

    private String getValue(String key) {
        String value = this.current.getOrNull(key);
        if (value == null && (value = this.root.getOrNull(key)) == null && (value = System.getProperty(key)) == null && (value = System.getenv(key)) == null) {
            this.accountException(new ConfigException("No property with name <" + key + "> exists"));
        }
        return value;
    }

    private String propertyValue(String value) {
        if (!this.isProperty(value)) {
            return value;
        }
        String rawValue = this.trimValue(value);
        String[] tokens = rawValue.split("[\\+\\-\\*\\/%]");
        if (tokens.length == 1) {
            return this.getValue(rawValue);
        }
        if (tokens.length > 2) {
            this.accountException(new ConfigException("Too many tokens for system property expression: " + tokens.length + " > 2 : " + value));
            return null;
        }
        char operator = rawValue.charAt(tokens[0].length());
        String arg1 = tokens[0].trim();
        String arg2 = tokens[1].trim();
        switch (operator) {
            case '+': {
                return this.add(arg1, arg2);
            }
            case '-': {
                return this.substract(arg1, arg2);
            }
            case '/': {
                return this.div(arg1, arg2);
            }
            case '%': {
                return this.remainder(arg1, arg2);
            }
            case '*': {
                return this.mul(arg1, arg2);
            }
        }
        this.accountException(new ConfigException("Unknown operator: '" + operator + "' in system property token: " + value));
        return null;
    }

    private String findNextProperty(String str) {
        int start = str.indexOf("$(");
        if (start != -1) {
            int encloses = 0;
            String expr = null;
            for (int i = start + 2; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '(') {
                    ++encloses;
                    continue;
                }
                if (c != ')') continue;
                if (encloses == 0) {
                    expr = str.substring(start, i + 1);
                    break;
                }
                --encloses;
            }
            if (encloses > 0 || expr == null) {
                this.accountException(new ConfigException("Unclosed property expression: " + str));
            }
            return expr;
        }
        return null;
    }

    private String expandValue(String value) {
        String property;
        String parsedValue = value;
        while ((property = this.findNextProperty(parsedValue)) != null) {
            int start = parsedValue.indexOf(property);
            parsedValue = StringUtils.concat(parsedValue.substring(0, start), this.propertyValue(property), parsedValue.substring(start + property.length()));
        }
        return parsedValue;
    }

    private void processRecord(String key, String value) {
        if (value.isEmpty() && key.length() > 2 && key.charAt(0) == '[' && key.charAt(key.length() - 1) == ']') {
            this.processSection(key.substring(1, key.length() - 1));
        } else if ("$(include".equals(key)) {
            if (this.configDir == null) {
                this.accountException(new ConfigException("'include' directive is not supported for Reader"));
            } else if (value.length() < 2 || value.charAt(value.length() - 1) != ')') {
                this.accountException(new ConfigException("Malformed 'include' directive: " + value));
            } else {
                String glob = this.expandValue(value.substring(0, value.length() - 1));
                try {
                    Stream<Path> filesStream = PathUtils.glob(this.configDir, glob, FileVisitOption.FOLLOW_LINKS);
                    Set files = filesStream.collect(Collectors.toCollection(() -> new TreeSet(CollectionsComparator.naturalOrder())));
                    if (files.isEmpty()) {
                        this.accountException(new ConfigException("No include files found for glob: " + glob + " in directory: " + this.configDir));
                    }
                    for (Path config : files) {
                        try {
                            new IniLoader(this.current, config);
                        }
                        catch (IOException | ConfigException e) {
                            this.accountException(new ConfigException("Failed to load file: " + config, e));
                        }
                    }
                }
                catch (IOException e) {
                    this.accountException(new ConfigException("Failed to list files under " + this.configDir + " with glob: " + glob));
                }
            }
        } else {
            this.current.put(key, this.expandValue(value));
        }
    }
}

