/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ParameterConfig<T> {
    private final String name;
    private final GenericFunction<String, ? extends T, ? extends Exception> parser;
    private final GenericFunction<? super T, ? extends T, ? extends Exception> validator;

    public ParameterConfig(String name, GenericFunction<String, ? extends T, ? extends Exception> parser, GenericFunction<? super T, ? extends T, ? extends Exception> validator) {
        this.name = name;
        this.parser = parser.andThen(validator);
        this.validator = validator;
    }

    public T extract(IniConfig config, T defaultValue) throws ConfigException {
        return config.get(this.name, defaultValue, this.parser);
    }

    public T validate(T value) throws ConfigException {
        if (value == null) {
            throw new ConfigException("Parameter " + this.name + " is not set");
        }
        try {
            return this.validator.apply(value);
        }
        catch (Throwable t) {
            throw new ConfigException("Validation for parameter " + this.name + " failed", t);
        }
    }
}

