/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import java.util.Collection;
import java.util.function.Supplier;
import ru.yandex.function.CharArrayProcessor;
import ru.yandex.function.GenericFunction;

public class CollectionParser<T, C extends Collection<T>, E extends Exception>
implements GenericFunction<String, C, E>,
CharArrayProcessor<C, E> {
    private final GenericFunction<String, ? extends T, E> parser;
    private final Supplier<? extends C> collectionSupplier;
    private final char delimiter;

    public CollectionParser(GenericFunction<String, ? extends T, E> parser, Supplier<? extends C> collectionSupplier) {
        this(parser, collectionSupplier, ',');
    }

    public CollectionParser(GenericFunction<String, ? extends T, E> parser, Supplier<? extends C> collectionSupplier, char delimiter) {
        this.parser = parser;
        this.collectionSupplier = collectionSupplier;
        this.delimiter = delimiter;
    }

    @Override
    public C apply(String value) throws E {
        return (C)((Collection)this.process(value.toCharArray()));
    }

    @Override
    public C process(char[] buf, int off, int len) throws E {
        Collection collection = (Collection)this.collectionSupplier.get();
        StringBuilder sb = new StringBuilder(len);
        boolean escaped = false;
        for (int i = 0; i < len; ++i) {
            char c = buf[i + off];
            if (escaped) {
                if (c == '\\' || c == this.delimiter) {
                    sb.append(c);
                } else {
                    sb.append('\\');
                    sb.append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == this.delimiter) {
                collection.add(this.parser.apply(sb.toString()));
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (escaped) {
            sb.append('\\');
        }
        collection.add(this.parser.apply(sb.toString()));
        return (C)collection;
    }
}

