/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.DoubleToIntegerValidator;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public enum DurationParser implements GenericFunction<String, Double, RuntimeException>
{
    INSTANCE;

    public static final GenericFunction<String, Integer, Exception> INTEGER;
    public static final GenericFunction<String, Long, Exception> LONG;
    public static final GenericFunction<String, Long, Exception> POSITIVE_LONG;
    private static final double MICROS_MULTIPLIER = 0.001;
    private static final double NANOS_MULTIPLIER = 1.0E-6;
    private static final double MILLIS_PER_SECOND = 1000.0;
    private static final int NONE = 0;
    private static final int SECONDS = 1;
    private static final int MINUTES = 2;
    private static final int HOURS = 3;
    private static final int DAYS = 4;
    private static final int WEEKS = 5;
    private static final double[] MULTIPLIERS;

    @Override
    public Double apply(String value) {
        double result;
        int type;
        int end = value.length() - 1;
        char last = value.charAt(end);
        switch (last) {
            case 's': {
                type = 1;
                break;
            }
            case 'm': {
                type = 2;
                break;
            }
            case 'h': {
                type = 3;
                break;
            }
            case 'd': {
                type = 4;
                break;
            }
            case 'w': {
                type = 5;
                break;
            }
            default: {
                type = 0;
            }
        }
        if (type == 0) {
            result = Double.parseDouble(value);
        } else {
            double multiplier;
            if (type == 1) {
                switch (value.charAt(end - 1)) {
                    case 'm': {
                        --end;
                        multiplier = 1.0;
                        break;
                    }
                    case 'n': {
                        --end;
                        multiplier = 1.0E-6;
                        break;
                    }
                    case '\u00b5': {
                        --end;
                        multiplier = 0.001;
                        break;
                    }
                    default: {
                        multiplier = 1000.0;
                        break;
                    }
                }
            } else {
                multiplier = MULTIPLIERS[type];
            }
            if (value.charAt(end - 1) == ' ') {
                --end;
            }
            result = Double.parseDouble(value.substring(0, end)) * multiplier;
        }
        return Math.ceil(result);
    }

    static {
        INTEGER = INSTANCE.andThen(NonNegativeValidator.instance()).andThen(DoubleToIntegerValidator.INSTANCE);
        LONG = INSTANCE.andThen(NonNegativeValidator.instance()).andThen(DoubleToLongValidator.INSTANCE);
        POSITIVE_LONG = INSTANCE.andThen(PositiveValidator.instance()).andThen(DoubleToLongValidator.INSTANCE);
        MULTIPLIERS = new double[]{1.0, 0.0, 60000.0, 3600000.0, 8.64E7, 6.048E8};
    }
}

