/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import java.io.File;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.Validator;

public class ExistingDirectoryValidator
extends Validator<File> {
    public static final ExistingDirectoryValidator INSTANCE = new ExistingDirectoryValidator();

    protected ExistingDirectoryValidator() {
        super(FileParser.INSTANCE);
    }

    @Override
    public void validate(File dir) throws Exception {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory " + dir + " doesn't exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " not a directory");
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Can't write to directory " + dir);
        }
    }
}

