/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import ru.yandex.parser.string.Parser;

public abstract class MemorySizeParser<T extends Number>
implements Parser<T> {
    private static final int NONE = 0;
    private static final int KILOS = 1;
    private static final int MEGAS = 2;
    private static final int GIGAS = 3;
    private static final double[] MULTIPLIERS = new double[]{1.0, 1024.0, 1048576.0, 1.073741824E9};
    private final Parser<? extends T> parser;

    public MemorySizeParser(Parser<? extends T> parser) {
        this.parser = parser;
    }

    protected abstract T fromDouble(double var1);

    @Override
    public T parse(String value) throws Exception {
        double doubleSize;
        int type;
        int end = value.length() - 1;
        char last = value.charAt(end);
        switch (last) {
            case 'K': 
            case 'k': {
                type = 1;
                break;
            }
            case 'M': 
            case 'm': {
                type = 2;
                break;
            }
            case 'G': 
            case 'g': {
                type = 3;
                break;
            }
            default: {
                type = 0;
            }
        }
        if (type == 0 && value.indexOf(46) == -1) {
            return (T)((Number)this.parser.parse(value));
        }
        double multiplier = MULTIPLIERS[type];
        if (value.charAt(end - 1) == ' ') {
            --end;
        }
        if ((doubleSize = Math.ceil(Double.parseDouble(value.substring(0, end)) * multiplier)) < 0.0) {
            throw new IllegalArgumentException("Non negative value expected");
        }
        T size = this.fromDouble(doubleSize);
        if (((Number)size).doubleValue() != doubleSize) {
            throw new IllegalArgumentException("Overflow occured");
        }
        return size;
    }
}

