/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import java.io.File;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.Validator;

public class OutputFileValidator
extends Validator<File> {
    public static final OutputFileValidator INSTANCE = new OutputFileValidator();
    private static final String PARENT = "Parent directory for file ";

    protected OutputFileValidator() {
        super(FileParser.INSTANCE);
    }

    @Override
    public void validate(File file) throws Exception {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IllegalArgumentException(file + " not a regular file");
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("File " + file + " cannot be open for writing");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null) {
                if (!parent.exists()) {
                    throw new IllegalArgumentException(PARENT + file + " doesn't exist");
                }
                if (!parent.isDirectory()) {
                    throw new IllegalArgumentException(PARENT + file + " not a directory");
                }
                if (!parent.canWrite()) {
                    throw new IllegalArgumentException(PARENT + file + " is not writable");
                }
            }
        }
    }
}

