/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import java.net.URI;
import java.net.URISyntaxException;
import ru.yandex.function.GenericFunction;

public enum URIParser implements GenericFunction<String, URI, Exception>
{
    INSTANCE{

        @Override
        public URI apply(String value) throws Exception {
            return new URI(value.trim()).parseServerAuthority();
        }
    }
    ,
    FRAGMENT_STRIPPING{

        @Override
        public URI apply(String value) throws Exception {
            return 2.stripFragment((URI)INSTANCE.apply(value));
        }
    };


    public static URI stripFragment(URI uri) throws URISyntaxException {
        if (uri.getRawFragment() == null) {
            return uri;
        }
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
    }
}

