/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.parser.string;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.BigIntegerParser;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.CharsetParser;
import ru.yandex.parser.string.DirectoryValidator;
import ru.yandex.parser.string.DoubleParser;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.ExistingDirectoryValidator;
import ru.yandex.parser.string.InputFileValidator;
import ru.yandex.parser.string.IntegerParser;
import ru.yandex.parser.string.LocaleParser;
import ru.yandex.parser.string.LogLevelParser;
import ru.yandex.parser.string.LongParser;
import ru.yandex.parser.string.OutputFileValidator;
import ru.yandex.parser.string.URIParser;

public interface ValuesStorage<E extends Exception> {
    public E parameterNotSetException(String var1);

    public E parseFailedException(String var1, String var2, Throwable var3);

    public String getOrNull(String var1);

    public String getLastOrNull(String var1);

    public Iterator<String> getAllOrNull(String var1);

    default public <T> T parse(String name, String value, GenericFunction<String, ? extends T, ? extends Exception> parser) throws E {
        try {
            return parser.apply(value);
        }
        catch (Exception e) {
            throw this.parseFailedException(name, value, e);
        }
    }

    default public <T, C extends Collection<? super T>> C parse(String name, Iterator<String> values, GenericFunction<String, ? extends T, ? extends Exception> parser, C collection) throws E {
        String value;
        while (values.hasNext() && (value = values.next()) != null) {
            T t;
            try {
                t = parser.apply(value);
            }
            catch (Exception e) {
                throw this.parseFailedException(name, value, e);
            }
            collection.add(t);
        }
        return collection;
    }

    default public <T, C extends Collection<T>> C parse(String name, Iterator<String> values, GenericFunction<String, ? extends C, ? extends Exception> parser) throws E {
        Collection collection;
        String value = values.next();
        try {
            collection = (Collection)parser.apply(value);
        }
        catch (Exception e) {
            throw this.parseFailedException(name, value, e);
        }
        while (values.hasNext()) {
            value = values.next();
            try {
                collection.addAll((Collection)parser.apply(value));
            }
            catch (Exception e) {
                throw this.parseFailedException(name, value, e);
            }
        }
        return (C)collection;
    }

    default public <T> T get(String name, GenericFunction<String, ? extends T, ? extends Exception> parser) throws E {
        String value = this.getOrNull(name);
        if (value == null) {
            throw this.parameterNotSetException(name);
        }
        return this.parse(name, value, parser);
    }

    default public <T> T get(String name, T defaultValue, GenericFunction<String, ? extends T, ? extends Exception> parser) throws E {
        String value = this.getOrNull(name);
        if (value == null) {
            return defaultValue;
        }
        return this.parse(name, value, parser);
    }

    default public <T> T getLast(String name, GenericFunction<String, ? extends T, ? extends Exception> parser) throws E {
        String value = this.getLastOrNull(name);
        if (value == null) {
            throw this.parameterNotSetException(name);
        }
        return this.parse(name, value, parser);
    }

    default public <T> T getLast(String name, T defaultValue, GenericFunction<String, ? extends T, ? extends Exception> parser) throws E {
        String value = this.getLastOrNull(name);
        if (value == null) {
            return defaultValue;
        }
        return this.parse(name, value, parser);
    }

    default public <T, C extends Collection<? super T>> C getAll(String name, GenericFunction<String, ? extends T, ? extends Exception> parser, C collection) throws E {
        Iterator<String> iter = this.getAllOrNull(name);
        if (iter == null) {
            throw this.parameterNotSetException(name);
        }
        return this.parse(name, iter, parser, collection);
    }

    default public <T, C extends Collection<? super T>> C getAll(String name, C defaultValue, GenericFunction<String, ? extends T, ? extends Exception> parser, C collection) throws E {
        Iterator<String> iter = this.getAllOrNull(name);
        if (iter == null) {
            return defaultValue;
        }
        return this.parse(name, iter, parser, collection);
    }

    default public <T, C extends Collection<T>> C getAll(String name, GenericFunction<String, ? extends C, ? extends Exception> parser) throws E {
        Iterator<String> iter = this.getAllOrNull(name);
        if (iter == null) {
            throw this.parameterNotSetException(name);
        }
        return this.parse(name, iter, parser);
    }

    default public <T, C extends Collection<T>> C getAll(String name, C defaultValue, GenericFunction<String, ? extends C, ? extends Exception> parser) throws E {
        Iterator<String> iter = this.getAllOrNull(name);
        if (iter == null) {
            return defaultValue;
        }
        return this.parse(name, iter, parser);
    }

    default public String getString(String name) throws E {
        return this.get(name, x -> x);
    }

    default public String getString(String name, String defaultValue) {
        String value = this.getOrNull(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    default public int getInt(String name) throws E {
        return this.get(name, IntegerParser.INSTANCE);
    }

    default public Integer getInt(String name, Integer defaultValue) throws E {
        return this.get(name, defaultValue, IntegerParser.INSTANCE);
    }

    default public long getLong(String name) throws E {
        return this.get(name, LongParser.INSTANCE);
    }

    default public Long getLong(String name, Long defaultValue) throws E {
        return this.get(name, defaultValue, LongParser.INSTANCE);
    }

    default public double getDouble(String name) throws E {
        return this.get(name, DoubleParser.INSTANCE);
    }

    default public Double getDouble(String name, Double defaultValue) throws E {
        return this.get(name, defaultValue, DoubleParser.INSTANCE);
    }

    default public BigInteger getBigInteger(String name) throws E {
        return this.get(name, BigIntegerParser.INSTANCE);
    }

    default public BigInteger getBigInteger(String name, BigInteger defaultValue) throws E {
        return this.get(name, defaultValue, BigIntegerParser.INSTANCE);
    }

    default public boolean getBoolean(String name) throws E {
        return this.get(name, BooleanParser.INSTANCE);
    }

    default public Boolean getBoolean(String name, Boolean defaultValue) throws E {
        return this.get(name, defaultValue, BooleanParser.INSTANCE);
    }

    default public <T extends Enum<T>> T getEnum(Class<T> t, String name) throws E {
        return (T)((Enum)this.get(name, new EnumParser<T>(t)));
    }

    default public <T extends Enum<T>> T getEnum(Class<T> t, String name, T defaultValue) throws E {
        return this.get(name, defaultValue, new EnumParser<T>(t));
    }

    default public File getInputFile(String name) throws E {
        return this.get(name, InputFileValidator.INSTANCE);
    }

    default public File getInputFile(String name, File defaultValue) throws E {
        return this.get(name, defaultValue, InputFileValidator.INSTANCE);
    }

    default public File getOutputFile(String name) throws E {
        return this.get(name, OutputFileValidator.INSTANCE);
    }

    default public File getOutputFile(String name, File defaultValue) throws E {
        return this.get(name, defaultValue, OutputFileValidator.INSTANCE);
    }

    default public File getDir(String name) throws E {
        return this.get(name, DirectoryValidator.INSTANCE);
    }

    default public File getDir(String name, File defaultValue) throws E {
        return this.get(name, defaultValue, DirectoryValidator.INSTANCE);
    }

    default public File getExistingDir(String name) throws E {
        return this.get(name, ExistingDirectoryValidator.INSTANCE);
    }

    default public File getExistingDir(String name, File defaultValue) throws E {
        return this.get(name, defaultValue, ExistingDirectoryValidator.INSTANCE);
    }

    default public Charset getCharset(String name) throws E {
        return this.get(name, CharsetParser.INSTANCE);
    }

    default public Charset getCharset(String name, Charset defaultValue) throws E {
        return this.get(name, defaultValue, CharsetParser.INSTANCE);
    }

    default public Locale getLocale(String name) throws E {
        return this.get(name, LocaleParser.INSTANCE);
    }

    default public Locale getLocale(String name, Locale defaultValue) throws E {
        return this.get(name, defaultValue, LocaleParser.INSTANCE);
    }

    default public Level getLogLevel(String name) throws E {
        return this.get(name, LogLevelParser.INSTANCE);
    }

    default public Level getLogLevel(String name, Level defaultValue) throws E {
        return this.get(name, defaultValue, LogLevelParser.INSTANCE);
    }

    default public URI getURI(String name) throws E {
        return this.get(name, URIParser.INSTANCE);
    }

    default public URI getURI(String name, URI defaultValue) throws E {
        return this.get(name, defaultValue, URIParser.INSTANCE);
    }

    default public int getIntegerDuration(String name) throws E {
        return this.get(name, DurationParser.INTEGER);
    }

    default public Integer getIntegerDuration(String name, Integer defaultValue) throws E {
        return this.get(name, defaultValue, DurationParser.INTEGER);
    }

    default public long getLongDuration(String name) throws E {
        return this.get(name, DurationParser.LONG);
    }

    default public Long getLongDuration(String name, Long defaultValue) throws E {
        return this.get(name, defaultValue, DurationParser.LONG);
    }
}

