/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.filesystem;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyingFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final Path target;

    public CopyingFileVisitor(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Files.createDirectories(this.target.resolve(this.source.relativize(dir)), new FileAttribute[0]);
        return FileVisitResult.CONTINUE;
    }

    public static void copy(Path source, Path target) throws IOException {
        Files.walkFileTree(source, new CopyingFileVisitor(source, target));
    }
}

