/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.filesystem;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public final class PathUtils {
    private PathUtils() {
    }

    public static Set<Path> listFiles(String path, LinkOption ... options) throws IOException {
        return PathUtils.listFiles(Paths.get(path, new String[0]), options);
    }

    public static Set<Path> listFiles(Path path, LinkOption ... options) throws IOException {
        HashSet<Path> files = new HashSet<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            for (Path file : ds) {
                if (!Files.isRegularFile(file, options)) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static Stream<Path> glob(Path root, String glob, FileVisitOption ... options) throws IOException {
        Path fullPath = root.resolve(glob);
        if (Files.exists(fullPath, new LinkOption[0])) {
            return Stream.of(fullPath);
        }
        PathMatcher matcher = root.getFileSystem().getPathMatcher("glob:" + fullPath);
        return Files.walk(root, options).filter(matcher::matches);
    }
}

