/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.string;

import ru.yandex.function.ByteArrayProcessor;

public enum HexStrings implements ByteArrayProcessor<char[], RuntimeException>
{
    UPPER{

        @Override
        protected char[] hex() {
            return UPPER_CHARS;
        }
    }
    ,
    LOWER{

        @Override
        protected char[] hex() {
            return LOWER_CHARS;
        }
    };

    public static final int SHIFT = 4;
    public static final int MASK = 15;
    private static final char[] UPPER_CHARS;
    private static final char[] LOWER_CHARS;

    protected abstract char[] hex();

    public char[] chars() {
        return this.hex();
    }

    @Override
    public char[] process(byte[] buf, int off, int len) {
        char[] table = this.hex();
        char[] chars = new char[len << 1];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            byte b = buf[i + off];
            chars[pos++] = table[b >>> 4 & 0xF];
            chars[pos++] = table[b & 0xF];
        }
        return chars;
    }

    public void toStringBuilder(StringBuilder sb, byte[] buf) {
        char[] table = this.hex();
        for (byte b : buf) {
            sb.append(table[b >>> 4 & 0xF]);
            sb.append(table[b & 0xF]);
        }
    }

    static {
        UPPER_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        LOWER_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

