/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.util.string;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.function.CharArrayVoidProcessor;
import sun.text.normalizer.NormalizerBase;
import sun.text.normalizer.NormalizerImpl;

public class NormalizingProcessor
extends CharArrayProcessable
implements CharArrayVoidProcessor<RuntimeException> {
    public static final int NORMALIZATION_BLOCK_SIZE = 1024;
    public static final int MAX_LOOKAHEAD = 4;
    private static final int MIN_NO_MAYBE = NormalizerImpl.getFromIndexesArr((int)6);
    private static final int BAD_CHAR_MASK = 98752;
    private final boolean allowDataSharing;
    private boolean shared = false;

    public NormalizingProcessor() {
        this(false);
    }

    public NormalizingProcessor(boolean allowDataSharing) {
        this.allowDataSharing = allowDataSharing;
    }

    public static boolean good(char c) {
        return c < MIN_NO_MAYBE || Character.isHighSurrogate(c) || (98752 >> Character.getType(c) & 1) == 0;
    }

    private static int nextBlockSize(char[] buf, int off, int len) {
        int blockSize;
        if (len <= 1028) {
            blockSize = len;
        } else {
            blockSize = 1025;
            for (int i = 1; i < 4; ++i) {
                if (!NormalizingProcessor.good(buf[off + 1024 + i])) continue;
                blockSize = 1024 + i;
                break;
            }
        }
        return blockSize;
    }

    @Override
    public void process(char[] buf, int off, int len) {
        NormalizerBase.QuickCheckResult check;
        int left;
        int blockSize;
        int inpos = off;
        for (left = len; left > 0 && (check = NormalizerImpl.quickCheck((char[])buf, (int)inpos, (int)(inpos + (blockSize = NormalizingProcessor.nextBlockSize(buf, inpos, left))), (int)MIN_NO_MAYBE, (int)17, (int)0, (boolean)false, null)) == NormalizerBase.YES; left -= blockSize) {
            inpos += blockSize;
        }
        if (left == 0) {
            if (this.allowDataSharing) {
                this.buf = buf;
                this.off = off;
                this.len = len;
                this.shared = true;
            } else {
                this.ensureBufCapacity(len);
                this.copyFrom(buf, off, len);
            }
        } else {
            this.off = 0;
            if (this.shared) {
                this.buf = new char[len];
                this.shared = false;
            } else {
                this.ensureBufCapacity(len);
            }
            this.len = inpos - off;
            System.arraycopy(buf, off, this.buf, 0, this.len);
            block1: while (left > 0) {
                blockSize = NormalizingProcessor.nextBlockSize(buf, inpos, left);
                while (true) {
                    int size;
                    if (this.len + (size = NormalizerImpl.compose((char[])buf, (int)inpos, (int)(inpos + blockSize), (char[])((char[])this.buf), (int)this.len, (int)((char[])this.buf).length, (int)0, null)) <= ((char[])this.buf).length) {
                        inpos += blockSize;
                        left -= blockSize;
                        this.len += size;
                        continue block1;
                    }
                    int newSize = Math.max(this.len + size, ((char[])this.buf).length << 1);
                    char[] newBuf = new char[newSize];
                    System.arraycopy(this.buf, 0, newBuf, 0, this.len);
                    this.buf = newBuf;
                }
            }
        }
    }
}

